/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CacheConfiguration;
import com.azure.resourcemanager.cdn.models.OriginGroupOverride;
import java.io.IOException;

public final class RouteConfigurationOverrideActionParameters
implements JsonSerializable<RouteConfigurationOverrideActionParameters> {
    private String typeName = "DeliveryRuleRouteConfigurationOverrideActionParameters";
    private OriginGroupOverride originGroupOverride;
    private CacheConfiguration cacheConfiguration;

    public String typeName() {
        return this.typeName;
    }

    public RouteConfigurationOverrideActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public OriginGroupOverride originGroupOverride() {
        return this.originGroupOverride;
    }

    public RouteConfigurationOverrideActionParameters withOriginGroupOverride(OriginGroupOverride originGroupOverride) {
        this.originGroupOverride = originGroupOverride;
        return this;
    }

    public CacheConfiguration cacheConfiguration() {
        return this.cacheConfiguration;
    }

    public RouteConfigurationOverrideActionParameters withCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
        return this;
    }

    public void validate() {
        if (this.originGroupOverride() != null) {
            this.originGroupOverride().validate();
        }
        if (this.cacheConfiguration() != null) {
            this.cacheConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeJsonField("originGroupOverride", (JsonSerializable)this.originGroupOverride);
        jsonWriter.writeJsonField("cacheConfiguration", (JsonSerializable)this.cacheConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static RouteConfigurationOverrideActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RouteConfigurationOverrideActionParameters)jsonReader.readObject(reader -> {
            RouteConfigurationOverrideActionParameters deserializedRouteConfigurationOverrideActionParameters = new RouteConfigurationOverrideActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("originGroupOverride".equals(fieldName)) {
                    deserializedRouteConfigurationOverrideActionParameters.originGroupOverride = OriginGroupOverride.fromJson(reader);
                    continue;
                }
                if ("cacheConfiguration".equals(fieldName)) {
                    deserializedRouteConfigurationOverrideActionParameters.cacheConfiguration = CacheConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteConfigurationOverrideActionParameters;
        });
    }
}

