/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.HttpErrorRangeParameters;
import com.azure.resourcemanager.cdn.models.ResponseBasedDetectedErrorTypes;
import java.io.IOException;
import java.util.List;

public final class ResponseBasedOriginErrorDetectionParameters
implements JsonSerializable<ResponseBasedOriginErrorDetectionParameters> {
    private ResponseBasedDetectedErrorTypes responseBasedDetectedErrorTypes;
    private Integer responseBasedFailoverThresholdPercentage;
    private List<HttpErrorRangeParameters> httpErrorRanges;

    public ResponseBasedDetectedErrorTypes responseBasedDetectedErrorTypes() {
        return this.responseBasedDetectedErrorTypes;
    }

    public ResponseBasedOriginErrorDetectionParameters withResponseBasedDetectedErrorTypes(ResponseBasedDetectedErrorTypes responseBasedDetectedErrorTypes) {
        this.responseBasedDetectedErrorTypes = responseBasedDetectedErrorTypes;
        return this;
    }

    public Integer responseBasedFailoverThresholdPercentage() {
        return this.responseBasedFailoverThresholdPercentage;
    }

    public ResponseBasedOriginErrorDetectionParameters withResponseBasedFailoverThresholdPercentage(Integer responseBasedFailoverThresholdPercentage) {
        this.responseBasedFailoverThresholdPercentage = responseBasedFailoverThresholdPercentage;
        return this;
    }

    public List<HttpErrorRangeParameters> httpErrorRanges() {
        return this.httpErrorRanges;
    }

    public ResponseBasedOriginErrorDetectionParameters withHttpErrorRanges(List<HttpErrorRangeParameters> httpErrorRanges) {
        this.httpErrorRanges = httpErrorRanges;
        return this;
    }

    public void validate() {
        if (this.httpErrorRanges() != null) {
            this.httpErrorRanges().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("responseBasedDetectedErrorTypes", this.responseBasedDetectedErrorTypes == null ? null : this.responseBasedDetectedErrorTypes.toString());
        jsonWriter.writeNumberField("responseBasedFailoverThresholdPercentage", (Number)this.responseBasedFailoverThresholdPercentage);
        jsonWriter.writeArrayField("httpErrorRanges", this.httpErrorRanges, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResponseBasedOriginErrorDetectionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ResponseBasedOriginErrorDetectionParameters)jsonReader.readObject(reader -> {
            ResponseBasedOriginErrorDetectionParameters deserializedResponseBasedOriginErrorDetectionParameters = new ResponseBasedOriginErrorDetectionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("responseBasedDetectedErrorTypes".equals(fieldName)) {
                    deserializedResponseBasedOriginErrorDetectionParameters.responseBasedDetectedErrorTypes = ResponseBasedDetectedErrorTypes.fromString(reader.getString());
                    continue;
                }
                if ("responseBasedFailoverThresholdPercentage".equals(fieldName)) {
                    deserializedResponseBasedOriginErrorDetectionParameters.responseBasedFailoverThresholdPercentage = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("httpErrorRanges".equals(fieldName)) {
                    List httpErrorRanges;
                    deserializedResponseBasedOriginErrorDetectionParameters.httpErrorRanges = httpErrorRanges = reader.readArray(reader1 -> HttpErrorRangeParameters.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResponseBasedOriginErrorDetectionParameters;
        });
    }
}

