/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.PostArgsOperator;
import com.azure.resourcemanager.cdn.models.Transform;
import java.io.IOException;
import java.util.List;

public final class PostArgsMatchConditionParameters
implements JsonSerializable<PostArgsMatchConditionParameters> {
    private String typeName = "DeliveryRulePostArgsConditionParameters";
    private String selector;
    private PostArgsOperator operator;
    private Boolean negateCondition;
    private List<String> matchValues;
    private List<Transform> transforms;
    private static final ClientLogger LOGGER = new ClientLogger(PostArgsMatchConditionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public PostArgsMatchConditionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String selector() {
        return this.selector;
    }

    public PostArgsMatchConditionParameters withSelector(String selector) {
        this.selector = selector;
        return this;
    }

    public PostArgsOperator operator() {
        return this.operator;
    }

    public PostArgsMatchConditionParameters withOperator(PostArgsOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public PostArgsMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<String> matchValues() {
        return this.matchValues;
    }

    public PostArgsMatchConditionParameters withMatchValues(List<String> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public List<Transform> transforms() {
        return this.transforms;
    }

    public PostArgsMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model PostArgsMatchConditionParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeStringField("selector", this.selector);
        jsonWriter.writeBooleanField("negateCondition", this.negateCondition);
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static PostArgsMatchConditionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (PostArgsMatchConditionParameters)jsonReader.readObject(reader -> {
            PostArgsMatchConditionParameters deserializedPostArgsMatchConditionParameters = new PostArgsMatchConditionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operator".equals(fieldName)) {
                    deserializedPostArgsMatchConditionParameters.operator = PostArgsOperator.fromString(reader.getString());
                    continue;
                }
                if ("selector".equals(fieldName)) {
                    deserializedPostArgsMatchConditionParameters.selector = reader.getString();
                    continue;
                }
                if ("negateCondition".equals(fieldName)) {
                    deserializedPostArgsMatchConditionParameters.negateCondition = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("matchValues".equals(fieldName)) {
                    List matchValues;
                    deserializedPostArgsMatchConditionParameters.matchValues = matchValues = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List transforms;
                    deserializedPostArgsMatchConditionParameters.transforms = transforms = reader.readArray(reader1 -> Transform.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPostArgsMatchConditionParameters;
        });
    }
}

