/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.io.IOException;

public final class MigrationWebApplicationFirewallMapping
implements JsonSerializable<MigrationWebApplicationFirewallMapping> {
    private ResourceReference migratedFrom;
    private ResourceReference migratedTo;

    public ResourceReference migratedFrom() {
        return this.migratedFrom;
    }

    public MigrationWebApplicationFirewallMapping withMigratedFrom(ResourceReference migratedFrom) {
        this.migratedFrom = migratedFrom;
        return this;
    }

    public ResourceReference migratedTo() {
        return this.migratedTo;
    }

    public MigrationWebApplicationFirewallMapping withMigratedTo(ResourceReference migratedTo) {
        this.migratedTo = migratedTo;
        return this;
    }

    public void validate() {
        if (this.migratedFrom() != null) {
            this.migratedFrom().validate();
        }
        if (this.migratedTo() != null) {
            this.migratedTo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("migratedFrom", (JsonSerializable)this.migratedFrom);
        jsonWriter.writeJsonField("migratedTo", (JsonSerializable)this.migratedTo);
        return jsonWriter.writeEndObject();
    }

    public static MigrationWebApplicationFirewallMapping fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationWebApplicationFirewallMapping)jsonReader.readObject(reader -> {
            MigrationWebApplicationFirewallMapping deserializedMigrationWebApplicationFirewallMapping = new MigrationWebApplicationFirewallMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("migratedFrom".equals(fieldName)) {
                    deserializedMigrationWebApplicationFirewallMapping.migratedFrom = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("migratedTo".equals(fieldName)) {
                    deserializedMigrationWebApplicationFirewallMapping.migratedTo = ResourceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationWebApplicationFirewallMapping;
        });
    }
}

