/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CookiesMatchConditionParameters;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.azure.resourcemanager.cdn.models.MatchVariable;
import java.io.IOException;

public final class DeliveryRuleCookiesCondition
extends DeliveryRuleCondition {
    private MatchVariable name = MatchVariable.COOKIES;
    private CookiesMatchConditionParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRuleCookiesCondition.class);

    @Override
    public MatchVariable name() {
        return this.name;
    }

    public CookiesMatchConditionParameters parameters() {
        return this.parameters;
    }

    public DeliveryRuleCookiesCondition withParameters(CookiesMatchConditionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parameters in model DeliveryRuleCookiesCondition"));
        }
        this.parameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static DeliveryRuleCookiesCondition fromJson(JsonReader jsonReader) throws IOException {
        return (DeliveryRuleCookiesCondition)jsonReader.readObject(reader -> {
            DeliveryRuleCookiesCondition deserializedDeliveryRuleCookiesCondition = new DeliveryRuleCookiesCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    deserializedDeliveryRuleCookiesCondition.parameters = CookiesMatchConditionParameters.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeliveryRuleCookiesCondition.name = MatchVariable.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryRuleCookiesCondition;
        });
    }
}

