/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CertificateType;
import java.io.IOException;

public final class CdnCertificateSourceParameters
implements JsonSerializable<CdnCertificateSourceParameters> {
    private String typeName = "CdnCertificateSourceParameters";
    private CertificateType certificateType;
    private static final ClientLogger LOGGER = new ClientLogger(CdnCertificateSourceParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public CdnCertificateSourceParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public CertificateType certificateType() {
        return this.certificateType;
    }

    public CdnCertificateSourceParameters withCertificateType(CertificateType certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    public void validate() {
        if (this.certificateType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property certificateType in model CdnCertificateSourceParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("certificateType", this.certificateType == null ? null : this.certificateType.toString());
        return jsonWriter.writeEndObject();
    }

    public static CdnCertificateSourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CdnCertificateSourceParameters)jsonReader.readObject(reader -> {
            CdnCertificateSourceParameters deserializedCdnCertificateSourceParameters = new CdnCertificateSourceParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("certificateType".equals(fieldName)) {
                    deserializedCdnCertificateSourceParameters.certificateType = CertificateType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCdnCertificateSourceParameters;
        });
    }
}

