/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.EndpointPropertiesUpdateParameters;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink;
import com.azure.resourcemanager.cdn.models.GeoFilter;
import com.azure.resourcemanager.cdn.models.OptimizationType;
import com.azure.resourcemanager.cdn.models.QueryStringCachingBehavior;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.UrlSigningKey;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class EndpointUpdateParameters
implements JsonSerializable<EndpointUpdateParameters> {
    private Map<String, String> tags;
    private EndpointPropertiesUpdateParameters innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public EndpointUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private EndpointPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public String originPath() {
        return this.innerProperties() == null ? null : this.innerProperties().originPath();
    }

    public EndpointUpdateParameters withOriginPath(String originPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withOriginPath(originPath);
        return this;
    }

    public List<String> contentTypesToCompress() {
        return this.innerProperties() == null ? null : this.innerProperties().contentTypesToCompress();
    }

    public EndpointUpdateParameters withContentTypesToCompress(List<String> contentTypesToCompress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withContentTypesToCompress(contentTypesToCompress);
        return this;
    }

    public String originHostHeader() {
        return this.innerProperties() == null ? null : this.innerProperties().originHostHeader();
    }

    public EndpointUpdateParameters withOriginHostHeader(String originHostHeader) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withOriginHostHeader(originHostHeader);
        return this;
    }

    public Boolean isCompressionEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isCompressionEnabled();
    }

    public EndpointUpdateParameters withIsCompressionEnabled(Boolean isCompressionEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withIsCompressionEnabled(isCompressionEnabled);
        return this;
    }

    public Boolean isHttpAllowed() {
        return this.innerProperties() == null ? null : this.innerProperties().isHttpAllowed();
    }

    public EndpointUpdateParameters withIsHttpAllowed(Boolean isHttpAllowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withIsHttpAllowed(isHttpAllowed);
        return this;
    }

    public Boolean isHttpsAllowed() {
        return this.innerProperties() == null ? null : this.innerProperties().isHttpsAllowed();
    }

    public EndpointUpdateParameters withIsHttpsAllowed(Boolean isHttpsAllowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withIsHttpsAllowed(isHttpsAllowed);
        return this;
    }

    public QueryStringCachingBehavior queryStringCachingBehavior() {
        return this.innerProperties() == null ? null : this.innerProperties().queryStringCachingBehavior();
    }

    public EndpointUpdateParameters withQueryStringCachingBehavior(QueryStringCachingBehavior queryStringCachingBehavior) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withQueryStringCachingBehavior(queryStringCachingBehavior);
        return this;
    }

    public OptimizationType optimizationType() {
        return this.innerProperties() == null ? null : this.innerProperties().optimizationType();
    }

    public EndpointUpdateParameters withOptimizationType(OptimizationType optimizationType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withOptimizationType(optimizationType);
        return this;
    }

    public String probePath() {
        return this.innerProperties() == null ? null : this.innerProperties().probePath();
    }

    public EndpointUpdateParameters withProbePath(String probePath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withProbePath(probePath);
        return this;
    }

    public List<GeoFilter> geoFilters() {
        return this.innerProperties() == null ? null : this.innerProperties().geoFilters();
    }

    public EndpointUpdateParameters withGeoFilters(List<GeoFilter> geoFilters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withGeoFilters(geoFilters);
        return this;
    }

    public ResourceReference defaultOriginGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultOriginGroup();
    }

    public EndpointUpdateParameters withDefaultOriginGroup(ResourceReference defaultOriginGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withDefaultOriginGroup(defaultOriginGroup);
        return this;
    }

    public List<UrlSigningKey> urlSigningKeys() {
        return this.innerProperties() == null ? null : this.innerProperties().urlSigningKeys();
    }

    public EndpointUpdateParameters withUrlSigningKeys(List<UrlSigningKey> urlSigningKeys) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withUrlSigningKeys(urlSigningKeys);
        return this;
    }

    public EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryPolicy();
    }

    public EndpointUpdateParameters withDeliveryPolicy(EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withDeliveryPolicy(deliveryPolicy);
        return this;
    }

    public EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink() {
        return this.innerProperties() == null ? null : this.innerProperties().webApplicationFirewallPolicyLink();
    }

    public EndpointUpdateParameters withWebApplicationFirewallPolicyLink(EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withWebApplicationFirewallPolicyLink(webApplicationFirewallPolicyLink);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static EndpointUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (EndpointUpdateParameters)jsonReader.readObject(reader -> {
            EndpointUpdateParameters deserializedEndpointUpdateParameters = new EndpointUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedEndpointUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedEndpointUpdateParameters.innerProperties = EndpointPropertiesUpdateParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEndpointUpdateParameters;
        });
    }
}

