/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.cdn.CdnManager;
import com.azure.resourcemanager.cdn.fluent.models.ProfileInner;
import com.azure.resourcemanager.cdn.models.CdnEndpoint;
import com.azure.resourcemanager.cdn.models.CheckNameAvailabilityResult;
import com.azure.resourcemanager.cdn.models.CustomDomainValidationResult;
import com.azure.resourcemanager.cdn.models.ResourceUsage;
import com.azure.resourcemanager.cdn.models.Sku;
import com.azure.resourcemanager.cdn.models.SkuName;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.util.Map;
import java.util.Set;
import reactor.core.publisher.Mono;

public interface CdnProfile
extends GroupableResource<CdnManager, ProfileInner>,
Refreshable<CdnProfile>,
Updatable<Update> {
    public Sku sku();

    public String resourceState();

    public Map<String, CdnEndpoint> endpoints();

    public String generateSsoUri();

    public Mono<String> generateSsoUriAsync();

    public void startEndpoint(String var1);

    public Mono<Void> startEndpointAsync(String var1);

    public void stopEndpoint(String var1);

    public Mono<Void> stopEndpointAsync(String var1);

    public void purgeEndpointContent(String var1, Set<String> var2);

    public Mono<Void> purgeEndpointContentAsync(String var1, Set<String> var2);

    public void loadEndpointContent(String var1, Set<String> var2);

    public Mono<Void> loadEndpointContentAsync(String var1, Set<String> var2);

    public CustomDomainValidationResult validateEndpointCustomDomain(String var1, String var2);

    public Mono<CustomDomainValidationResult> validateEndpointCustomDomainAsync(String var1, String var2);

    public CheckNameAvailabilityResult checkEndpointNameAvailability(String var1);

    public Mono<CheckNameAvailabilityResult> checkEndpointNameAvailabilityAsync(String var1);

    public boolean isPremiumVerizon();

    public PagedIterable<ResourceUsage> listResourceUsage();

    public static interface Update
    extends Appliable<CdnProfile>,
    UpdateStages.WithEndpoint,
    Resource.UpdateWithTags<Update> {
    }

    public static interface UpdateStages {

        public static interface WithEndpoint {
            public Update withNewEndpoint(String var1);

            public CdnEndpoint.UpdateDefinitionStages.Blank.StandardEndpoint<Update> defineNewEndpoint();

            public CdnEndpoint.UpdateDefinitionStages.Blank.StandardEndpoint<Update> defineNewEndpoint(String var1);

            public CdnEndpoint.UpdateDefinitionStages.WithStandardAttach<Update> defineNewEndpoint(String var1, String var2);

            public Update withNewPremiumEndpoint(String var1);

            public CdnEndpoint.UpdateDefinitionStages.Blank.PremiumEndpoint<Update> defineNewPremiumEndpoint();

            public CdnEndpoint.UpdateDefinitionStages.Blank.PremiumEndpoint<Update> defineNewPremiumEndpoint(String var1);

            public CdnEndpoint.UpdateDefinitionStages.WithPremiumAttach<Update> defineNewPremiumEndpoint(String var1, String var2);

            public CdnEndpoint.UpdateStandardEndpoint updateEndpoint(String var1);

            public CdnEndpoint.UpdatePremiumEndpoint updatePremiumEndpoint(String var1);

            public Update withoutEndpoint(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<CdnProfile>,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithPremiumVerizonCreate
        extends WithCreate {
            public WithPremiumVerizonCreate withNewPremiumEndpoint(String var1);

            public CdnEndpoint.DefinitionStages.Blank.PremiumEndpoint<WithPremiumVerizonCreate> defineNewPremiumEndpoint();

            public CdnEndpoint.DefinitionStages.Blank.PremiumEndpoint<WithPremiumVerizonCreate> defineNewPremiumEndpoint(String var1);

            public CdnEndpoint.DefinitionStages.WithPremiumAttach<WithPremiumVerizonCreate> defineNewPremiumEndpoint(String var1, String var2);
        }

        public static interface WithStandardCreate
        extends WithCreate {
            public WithStandardCreate withNewEndpoint(String var1);

            public CdnEndpoint.DefinitionStages.Blank.StandardEndpoint<WithStandardCreate> defineNewEndpoint();

            public CdnEndpoint.DefinitionStages.Blank.StandardEndpoint<WithStandardCreate> defineNewEndpoint(String var1);

            public CdnEndpoint.DefinitionStages.WithStandardAttach<WithStandardCreate> defineNewEndpoint(String var1, String var2);
        }

        public static interface WithSku {
            @Deprecated
            public WithStandardCreate withStandardAkamaiSku();

            public WithStandardCreate withStandardVerizonSku();

            public WithPremiumVerizonCreate withPremiumVerizonSku();

            public WithStandardCreate withStandardMicrosoftSku();

            public WithStandardCreate withSku(SkuName var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSku> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithStandardCreate,
    DefinitionStages.WithPremiumVerizonCreate,
    DefinitionStages.WithCreate {
    }
}

