/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RoleAssignmentScheduleRequestPropertiesScheduleInfo
implements JsonSerializable<RoleAssignmentScheduleRequestPropertiesScheduleInfo> {
    private OffsetDateTime startDateTime;
    private RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration expiration;

    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    public RoleAssignmentScheduleRequestPropertiesScheduleInfo withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration expiration() {
        return this.expiration;
    }

    public RoleAssignmentScheduleRequestPropertiesScheduleInfo withExpiration(RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration expiration) {
        this.expiration = expiration;
        return this;
    }

    public void validate() {
        if (this.expiration() != null) {
            this.expiration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startDateTime", this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeJsonField("expiration", (JsonSerializable)this.expiration);
        return jsonWriter.writeEndObject();
    }

    public static RoleAssignmentScheduleRequestPropertiesScheduleInfo fromJson(JsonReader jsonReader) throws IOException {
        return (RoleAssignmentScheduleRequestPropertiesScheduleInfo)jsonReader.readObject(reader -> {
            RoleAssignmentScheduleRequestPropertiesScheduleInfo deserializedRoleAssignmentScheduleRequestPropertiesScheduleInfo = new RoleAssignmentScheduleRequestPropertiesScheduleInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startDateTime".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestPropertiesScheduleInfo.startDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expiration".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestPropertiesScheduleInfo.expiration = RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleAssignmentScheduleRequestPropertiesScheduleInfo;
        });
    }
}

