/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphResourceReference;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphResourceVisualization;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphTrending
extends MicrosoftGraphEntity {
    private OffsetDateTime lastModifiedDateTime;
    private MicrosoftGraphResourceReference resourceReference;
    private MicrosoftGraphResourceVisualization resourceVisualization;
    private Double weight;
    private MicrosoftGraphEntity resource;
    private Map<String, Object> additionalProperties;

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphTrending withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    public MicrosoftGraphResourceReference resourceReference() {
        return this.resourceReference;
    }

    public MicrosoftGraphTrending withResourceReference(MicrosoftGraphResourceReference resourceReference) {
        this.resourceReference = resourceReference;
        return this;
    }

    public MicrosoftGraphResourceVisualization resourceVisualization() {
        return this.resourceVisualization;
    }

    public MicrosoftGraphTrending withResourceVisualization(MicrosoftGraphResourceVisualization resourceVisualization) {
        this.resourceVisualization = resourceVisualization;
        return this;
    }

    public Double weight() {
        return this.weight;
    }

    public MicrosoftGraphTrending withWeight(Double weight) {
        this.weight = weight;
        return this;
    }

    public MicrosoftGraphEntity resource() {
        return this.resource;
    }

    public MicrosoftGraphTrending withResource(MicrosoftGraphEntity resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphTrending withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphTrending withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.resourceReference() != null) {
            this.resourceReference().validate();
        }
        if (this.resourceVisualization() != null) {
            this.resourceVisualization().validate();
        }
        if (this.resource() != null) {
            this.resource().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeJsonField("resourceReference", (JsonSerializable)this.resourceReference);
        jsonWriter.writeJsonField("resourceVisualization", (JsonSerializable)this.resourceVisualization);
        jsonWriter.writeNumberField("weight", (Number)this.weight);
        jsonWriter.writeJsonField("resource", (JsonSerializable)this.resource);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphTrending fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphTrending)jsonReader.readObject(reader -> {
            MicrosoftGraphTrending deserializedMicrosoftGraphTrending = new MicrosoftGraphTrending();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTrending.withId(reader.getString());
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTrending.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resourceReference".equals(fieldName)) {
                    deserializedMicrosoftGraphTrending.resourceReference = MicrosoftGraphResourceReference.fromJson(reader);
                    continue;
                }
                if ("resourceVisualization".equals(fieldName)) {
                    deserializedMicrosoftGraphTrending.resourceVisualization = MicrosoftGraphResourceVisualization.fromJson(reader);
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    deserializedMicrosoftGraphTrending.weight = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("resource".equals(fieldName)) {
                    deserializedMicrosoftGraphTrending.resource = MicrosoftGraphEntity.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphTrending.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphTrending;
        });
    }
}

