/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphChangeTrackedEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphSchedulingGroup
extends MicrosoftGraphChangeTrackedEntity {
    private String displayName;
    private Boolean isActive;
    private List<String> userIds;
    private Map<String, Object> additionalProperties;

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphSchedulingGroup withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Boolean isActive() {
        return this.isActive;
    }

    public MicrosoftGraphSchedulingGroup withIsActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    public List<String> userIds() {
        return this.userIds;
    }

    public MicrosoftGraphSchedulingGroup withUserIds(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphSchedulingGroup withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphSchedulingGroup withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphSchedulingGroup withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphSchedulingGroup withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphSchedulingGroup withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeBooleanField("isActive", this.isActive);
        jsonWriter.writeArrayField("userIds", this.userIds, (writer, element) -> writer.writeString(element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphSchedulingGroup fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphSchedulingGroup)jsonReader.readObject(reader -> {
            MicrosoftGraphSchedulingGroup deserializedMicrosoftGraphSchedulingGroup = new MicrosoftGraphSchedulingGroup();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedulingGroup.withId(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedulingGroup.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedulingGroup.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedulingGroup.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedulingGroup.displayName = reader.getString();
                    continue;
                }
                if ("isActive".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedulingGroup.isActive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("userIds".equals(fieldName)) {
                    List userIds;
                    deserializedMicrosoftGraphSchedulingGroup.userIds = userIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphSchedulingGroup.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphSchedulingGroup;
        });
    }
}

