/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphFreeBusyError;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScheduleItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphWorkingHours;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphScheduleInformation
implements JsonSerializable<MicrosoftGraphScheduleInformation> {
    private String availabilityView;
    private MicrosoftGraphFreeBusyError error;
    private String scheduleId;
    private List<MicrosoftGraphScheduleItem> scheduleItems;
    private MicrosoftGraphWorkingHours workingHours;
    private Map<String, Object> additionalProperties;

    public String availabilityView() {
        return this.availabilityView;
    }

    public MicrosoftGraphScheduleInformation withAvailabilityView(String availabilityView) {
        this.availabilityView = availabilityView;
        return this;
    }

    public MicrosoftGraphFreeBusyError error() {
        return this.error;
    }

    public MicrosoftGraphScheduleInformation withError(MicrosoftGraphFreeBusyError error) {
        this.error = error;
        return this;
    }

    public String scheduleId() {
        return this.scheduleId;
    }

    public MicrosoftGraphScheduleInformation withScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
        return this;
    }

    public List<MicrosoftGraphScheduleItem> scheduleItems() {
        return this.scheduleItems;
    }

    public MicrosoftGraphScheduleInformation withScheduleItems(List<MicrosoftGraphScheduleItem> scheduleItems) {
        this.scheduleItems = scheduleItems;
        return this;
    }

    public MicrosoftGraphWorkingHours workingHours() {
        return this.workingHours;
    }

    public MicrosoftGraphScheduleInformation withWorkingHours(MicrosoftGraphWorkingHours workingHours) {
        this.workingHours = workingHours;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphScheduleInformation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
        if (this.scheduleItems() != null) {
            this.scheduleItems().forEach(e -> e.validate());
        }
        if (this.workingHours() != null) {
            this.workingHours().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("availabilityView", this.availabilityView);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeStringField("scheduleId", this.scheduleId);
        jsonWriter.writeArrayField("scheduleItems", this.scheduleItems, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("workingHours", (JsonSerializable)this.workingHours);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphScheduleInformation fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphScheduleInformation)jsonReader.readObject(reader -> {
            MicrosoftGraphScheduleInformation deserializedMicrosoftGraphScheduleInformation = new MicrosoftGraphScheduleInformation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("availabilityView".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleInformation.availabilityView = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleInformation.error = MicrosoftGraphFreeBusyError.fromJson(reader);
                    continue;
                }
                if ("scheduleId".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleInformation.scheduleId = reader.getString();
                    continue;
                }
                if ("scheduleItems".equals(fieldName)) {
                    List scheduleItems;
                    deserializedMicrosoftGraphScheduleInformation.scheduleItems = scheduleItems = reader.readArray(reader1 -> MicrosoftGraphScheduleItem.fromJson(reader1));
                    continue;
                }
                if ("workingHours".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleInformation.workingHours = MicrosoftGraphWorkingHours.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphScheduleInformation.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphScheduleInformation;
        });
    }
}

