/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class MicrosoftGraphPasswordCredentialInner
implements JsonSerializable<MicrosoftGraphPasswordCredentialInner> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private Base64Url customKeyIdentifier;
    private String displayName;
    private OffsetDateTime endDateTime;
    private String hint;
    private UUID keyId;
    private String secretText;
    private OffsetDateTime startDateTime;
    private Map<String, Object> additionalProperties;

    public byte[] customKeyIdentifier() {
        if (this.customKeyIdentifier == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.customKeyIdentifier.decodedBytes();
    }

    public MicrosoftGraphPasswordCredentialInner withCustomKeyIdentifier(byte[] customKeyIdentifier) {
        this.customKeyIdentifier = customKeyIdentifier == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])customKeyIdentifier));
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphPasswordCredentialInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    public MicrosoftGraphPasswordCredentialInner withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    public String hint() {
        return this.hint;
    }

    public MicrosoftGraphPasswordCredentialInner withHint(String hint) {
        this.hint = hint;
        return this;
    }

    public UUID keyId() {
        return this.keyId;
    }

    public MicrosoftGraphPasswordCredentialInner withKeyId(UUID keyId) {
        this.keyId = keyId;
        return this;
    }

    public String secretText() {
        return this.secretText;
    }

    public MicrosoftGraphPasswordCredentialInner withSecretText(String secretText) {
        this.secretText = secretText;
        return this;
    }

    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    public MicrosoftGraphPasswordCredentialInner withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphPasswordCredentialInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("customKeyIdentifier", Objects.toString(this.customKeyIdentifier, null));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("endDateTime", this.endDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime));
        jsonWriter.writeStringField("hint", this.hint);
        jsonWriter.writeStringField("keyId", Objects.toString(this.keyId, null));
        jsonWriter.writeStringField("secretText", this.secretText);
        jsonWriter.writeStringField("startDateTime", this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphPasswordCredentialInner fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphPasswordCredentialInner)jsonReader.readObject(reader -> {
            MicrosoftGraphPasswordCredentialInner deserializedMicrosoftGraphPasswordCredentialInner = new MicrosoftGraphPasswordCredentialInner();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("customKeyIdentifier".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.customKeyIdentifier = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.displayName = reader.getString();
                    continue;
                }
                if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.endDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("hint".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.hint = reader.getString();
                    continue;
                }
                if ("keyId".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.keyId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("secretText".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.secretText = reader.getString();
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.startDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphPasswordCredentialInner.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphPasswordCredentialInner;
        });
    }
}

