/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOutlookCategory;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphOutlookUser
extends MicrosoftGraphEntity {
    private List<MicrosoftGraphOutlookCategory> masterCategories;
    private Map<String, Object> additionalProperties;

    public List<MicrosoftGraphOutlookCategory> masterCategories() {
        return this.masterCategories;
    }

    public MicrosoftGraphOutlookUser withMasterCategories(List<MicrosoftGraphOutlookCategory> masterCategories) {
        this.masterCategories = masterCategories;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOutlookUser withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOutlookUser withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.masterCategories() != null) {
            this.masterCategories().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeArrayField("masterCategories", this.masterCategories, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOutlookUser fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOutlookUser)jsonReader.readObject(reader -> {
            MicrosoftGraphOutlookUser deserializedMicrosoftGraphOutlookUser = new MicrosoftGraphOutlookUser();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOutlookUser.withId(reader.getString());
                    continue;
                }
                if ("masterCategories".equals(fieldName)) {
                    List masterCategories;
                    deserializedMicrosoftGraphOutlookUser.masterCategories = masterCategories = reader.readArray(reader1 -> MicrosoftGraphOutlookCategory.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOutlookUser.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOutlookUser;
        });
    }
}

