/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRule;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRuleTarget;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRuleType;
import java.io.IOException;

public final class RoleManagementPolicyAuthenticationContextRule
extends RoleManagementPolicyRule {
    private RoleManagementPolicyRuleType ruleType = RoleManagementPolicyRuleType.ROLE_MANAGEMENT_POLICY_AUTHENTICATION_CONTEXT_RULE;
    private Boolean isEnabled;
    private String claimValue;

    @Override
    public RoleManagementPolicyRuleType ruleType() {
        return this.ruleType;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public RoleManagementPolicyAuthenticationContextRule withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public String claimValue() {
        return this.claimValue;
    }

    public RoleManagementPolicyAuthenticationContextRule withClaimValue(String claimValue) {
        this.claimValue = claimValue;
        return this;
    }

    @Override
    public RoleManagementPolicyAuthenticationContextRule withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public RoleManagementPolicyAuthenticationContextRule withTarget(RoleManagementPolicyRuleTarget target) {
        super.withTarget(target);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("target", (JsonSerializable)this.target());
        jsonWriter.writeStringField("ruleType", this.ruleType == null ? null : this.ruleType.toString());
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeStringField("claimValue", this.claimValue);
        return jsonWriter.writeEndObject();
    }

    public static RoleManagementPolicyAuthenticationContextRule fromJson(JsonReader jsonReader) throws IOException {
        return (RoleManagementPolicyAuthenticationContextRule)jsonReader.readObject(reader -> {
            RoleManagementPolicyAuthenticationContextRule deserializedRoleManagementPolicyAuthenticationContextRule = new RoleManagementPolicyAuthenticationContextRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRoleManagementPolicyAuthenticationContextRule.withId(reader.getString());
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedRoleManagementPolicyAuthenticationContextRule.withTarget(RoleManagementPolicyRuleTarget.fromJson(reader));
                    continue;
                }
                if ("ruleType".equals(fieldName)) {
                    deserializedRoleManagementPolicyAuthenticationContextRule.ruleType = RoleManagementPolicyRuleType.fromString(reader.getString());
                    continue;
                }
                if ("isEnabled".equals(fieldName)) {
                    deserializedRoleManagementPolicyAuthenticationContextRule.isEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("claimValue".equals(fieldName)) {
                    deserializedRoleManagementPolicyAuthenticationContextRule.claimValue = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleManagementPolicyAuthenticationContextRule;
        });
    }
}

