/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphNotebook;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteEntityHierarchyModel;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteSection;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphSectionGroup
extends MicrosoftGraphOnenoteEntityHierarchyModel {
    private String sectionGroupsUrl;
    private String sectionsUrl;
    private MicrosoftGraphNotebook parentNotebook;
    private MicrosoftGraphSectionGroup parentSectionGroup;
    private List<MicrosoftGraphSectionGroup> sectionGroups;
    private List<MicrosoftGraphOnenoteSection> sections;
    private Map<String, Object> additionalProperties;

    public String sectionGroupsUrl() {
        return this.sectionGroupsUrl;
    }

    public MicrosoftGraphSectionGroup withSectionGroupsUrl(String sectionGroupsUrl) {
        this.sectionGroupsUrl = sectionGroupsUrl;
        return this;
    }

    public String sectionsUrl() {
        return this.sectionsUrl;
    }

    public MicrosoftGraphSectionGroup withSectionsUrl(String sectionsUrl) {
        this.sectionsUrl = sectionsUrl;
        return this;
    }

    public MicrosoftGraphNotebook parentNotebook() {
        return this.parentNotebook;
    }

    public MicrosoftGraphSectionGroup withParentNotebook(MicrosoftGraphNotebook parentNotebook) {
        this.parentNotebook = parentNotebook;
        return this;
    }

    public MicrosoftGraphSectionGroup parentSectionGroup() {
        return this.parentSectionGroup;
    }

    public MicrosoftGraphSectionGroup withParentSectionGroup(MicrosoftGraphSectionGroup parentSectionGroup) {
        this.parentSectionGroup = parentSectionGroup;
        return this;
    }

    public List<MicrosoftGraphSectionGroup> sectionGroups() {
        return this.sectionGroups;
    }

    public MicrosoftGraphSectionGroup withSectionGroups(List<MicrosoftGraphSectionGroup> sectionGroups) {
        this.sectionGroups = sectionGroups;
        return this;
    }

    public List<MicrosoftGraphOnenoteSection> sections() {
        return this.sections;
    }

    public MicrosoftGraphSectionGroup withSections(List<MicrosoftGraphOnenoteSection> sections) {
        this.sections = sections;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphSectionGroup withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphSectionGroup withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    @Override
    public MicrosoftGraphSectionGroup withDisplayName(String displayName) {
        super.withDisplayName(displayName);
        return this;
    }

    @Override
    public MicrosoftGraphSectionGroup withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphSectionGroup withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphSectionGroup withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphSectionGroup withSelf(String self) {
        super.withSelf(self);
        return this;
    }

    @Override
    public MicrosoftGraphSectionGroup withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parentNotebook() != null) {
            this.parentNotebook().validate();
        }
        if (this.parentSectionGroup() != null) {
            this.parentSectionGroup().validate();
        }
        if (this.sectionGroups() != null) {
            this.sectionGroups().forEach(e -> e.validate());
        }
        if (this.sections() != null) {
            this.sections().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("self", this.self());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeJsonField("createdBy", (JsonSerializable)this.createdBy());
        jsonWriter.writeStringField("displayName", this.displayName());
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeStringField("sectionGroupsUrl", this.sectionGroupsUrl);
        jsonWriter.writeStringField("sectionsUrl", this.sectionsUrl);
        jsonWriter.writeJsonField("parentNotebook", (JsonSerializable)this.parentNotebook);
        jsonWriter.writeJsonField("parentSectionGroup", (JsonSerializable)this.parentSectionGroup);
        jsonWriter.writeArrayField("sectionGroups", this.sectionGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sections", this.sections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphSectionGroup fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphSectionGroup)jsonReader.readObject(reader -> {
            MicrosoftGraphSectionGroup deserializedMicrosoftGraphSectionGroup = new MicrosoftGraphSectionGroup();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withId(reader.getString());
                    continue;
                }
                if ("self".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withSelf(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withCreatedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withDisplayName(reader.getString());
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("sectionGroupsUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.sectionGroupsUrl = reader.getString();
                    continue;
                }
                if ("sectionsUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.sectionsUrl = reader.getString();
                    continue;
                }
                if ("parentNotebook".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.parentNotebook = MicrosoftGraphNotebook.fromJson(reader);
                    continue;
                }
                if ("parentSectionGroup".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.parentSectionGroup = MicrosoftGraphSectionGroup.fromJson(reader);
                    continue;
                }
                if ("sectionGroups".equals(fieldName)) {
                    List sectionGroups;
                    deserializedMicrosoftGraphSectionGroup.sectionGroups = sectionGroups = reader.readArray(reader1 -> MicrosoftGraphSectionGroup.fromJson(reader1));
                    continue;
                }
                if ("sections".equals(fieldName)) {
                    List sections;
                    deserializedMicrosoftGraphSectionGroup.sections = sections = reader.readArray(reader1 -> MicrosoftGraphOnenoteSection.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphSectionGroup.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphSectionGroup;
        });
    }
}

