/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphNotebookLinks;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteUserRole;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphCopyNotebookModel
implements JsonSerializable<MicrosoftGraphCopyNotebookModel> {
    private String createdBy;
    private MicrosoftGraphIdentitySet createdByIdentity;
    private OffsetDateTime createdTime;
    private String id;
    private Boolean isDefault;
    private Boolean isShared;
    private String lastModifiedBy;
    private MicrosoftGraphIdentitySet lastModifiedByIdentity;
    private OffsetDateTime lastModifiedTime;
    private MicrosoftGraphNotebookLinks links;
    private String name;
    private String sectionGroupsUrl;
    private String sectionsUrl;
    private String self;
    private MicrosoftGraphOnenoteUserRole userRole;
    private Map<String, Object> additionalProperties;

    public String createdBy() {
        return this.createdBy;
    }

    public MicrosoftGraphCopyNotebookModel withCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public MicrosoftGraphIdentitySet createdByIdentity() {
        return this.createdByIdentity;
    }

    public MicrosoftGraphCopyNotebookModel withCreatedByIdentity(MicrosoftGraphIdentitySet createdByIdentity) {
        this.createdByIdentity = createdByIdentity;
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public MicrosoftGraphCopyNotebookModel withCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public String id() {
        return this.id;
    }

    public MicrosoftGraphCopyNotebookModel withId(String id) {
        this.id = id;
        return this;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public MicrosoftGraphCopyNotebookModel withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public Boolean isShared() {
        return this.isShared;
    }

    public MicrosoftGraphCopyNotebookModel withIsShared(Boolean isShared) {
        this.isShared = isShared;
        return this;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public MicrosoftGraphCopyNotebookModel withLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    public MicrosoftGraphIdentitySet lastModifiedByIdentity() {
        return this.lastModifiedByIdentity;
    }

    public MicrosoftGraphCopyNotebookModel withLastModifiedByIdentity(MicrosoftGraphIdentitySet lastModifiedByIdentity) {
        this.lastModifiedByIdentity = lastModifiedByIdentity;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public MicrosoftGraphCopyNotebookModel withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public MicrosoftGraphNotebookLinks links() {
        return this.links;
    }

    public MicrosoftGraphCopyNotebookModel withLinks(MicrosoftGraphNotebookLinks links) {
        this.links = links;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MicrosoftGraphCopyNotebookModel withName(String name) {
        this.name = name;
        return this;
    }

    public String sectionGroupsUrl() {
        return this.sectionGroupsUrl;
    }

    public MicrosoftGraphCopyNotebookModel withSectionGroupsUrl(String sectionGroupsUrl) {
        this.sectionGroupsUrl = sectionGroupsUrl;
        return this;
    }

    public String sectionsUrl() {
        return this.sectionsUrl;
    }

    public MicrosoftGraphCopyNotebookModel withSectionsUrl(String sectionsUrl) {
        this.sectionsUrl = sectionsUrl;
        return this;
    }

    public String self() {
        return this.self;
    }

    public MicrosoftGraphCopyNotebookModel withSelf(String self) {
        this.self = self;
        return this;
    }

    public MicrosoftGraphOnenoteUserRole userRole() {
        return this.userRole;
    }

    public MicrosoftGraphCopyNotebookModel withUserRole(MicrosoftGraphOnenoteUserRole userRole) {
        this.userRole = userRole;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphCopyNotebookModel withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.createdByIdentity() != null) {
            this.createdByIdentity().validate();
        }
        if (this.lastModifiedByIdentity() != null) {
            this.lastModifiedByIdentity().validate();
        }
        if (this.links() != null) {
            this.links().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdBy", this.createdBy);
        jsonWriter.writeJsonField("createdByIdentity", (JsonSerializable)this.createdByIdentity);
        jsonWriter.writeStringField("createdTime", this.createdTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdTime));
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeBooleanField("isShared", this.isShared);
        jsonWriter.writeStringField("lastModifiedBy", this.lastModifiedBy);
        jsonWriter.writeJsonField("lastModifiedByIdentity", (JsonSerializable)this.lastModifiedByIdentity);
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeJsonField("links", (JsonSerializable)this.links);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("sectionGroupsUrl", this.sectionGroupsUrl);
        jsonWriter.writeStringField("sectionsUrl", this.sectionsUrl);
        jsonWriter.writeStringField("self", this.self);
        jsonWriter.writeStringField("userRole", this.userRole == null ? null : this.userRole.toString());
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphCopyNotebookModel fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphCopyNotebookModel)jsonReader.readObject(reader -> {
            MicrosoftGraphCopyNotebookModel deserializedMicrosoftGraphCopyNotebookModel = new MicrosoftGraphCopyNotebookModel();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.createdBy = reader.getString();
                    continue;
                }
                if ("createdByIdentity".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.createdByIdentity = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.createdTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.id = reader.getString();
                    continue;
                }
                if ("isDefault".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.isDefault = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isShared".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.isShared = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.lastModifiedBy = reader.getString();
                    continue;
                }
                if ("lastModifiedByIdentity".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.lastModifiedByIdentity = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("links".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.links = MicrosoftGraphNotebookLinks.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.name = reader.getString();
                    continue;
                }
                if ("sectionGroupsUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.sectionGroupsUrl = reader.getString();
                    continue;
                }
                if ("sectionsUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.sectionsUrl = reader.getString();
                    continue;
                }
                if ("self".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.self = reader.getString();
                    continue;
                }
                if ("userRole".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.userRole = MicrosoftGraphOnenoteUserRole.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphCopyNotebookModel.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphCopyNotebookModel;
        });
    }
}

