/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.WebJobType;
import java.io.IOException;
import java.util.Map;

public final class WebJobProperties
implements JsonSerializable<WebJobProperties> {
    private String runCommand;
    private String url;
    private String extraInfoUrl;
    private WebJobType webJobType;
    private String error;
    private Boolean usingSdk;
    private Map<String, Object> settings;

    public String runCommand() {
        return this.runCommand;
    }

    public WebJobProperties withRunCommand(String runCommand) {
        this.runCommand = runCommand;
        return this;
    }

    public String url() {
        return this.url;
    }

    public WebJobProperties withUrl(String url) {
        this.url = url;
        return this;
    }

    public String extraInfoUrl() {
        return this.extraInfoUrl;
    }

    public WebJobProperties withExtraInfoUrl(String extraInfoUrl) {
        this.extraInfoUrl = extraInfoUrl;
        return this;
    }

    public WebJobType webJobType() {
        return this.webJobType;
    }

    public WebJobProperties withWebJobType(WebJobType webJobType) {
        this.webJobType = webJobType;
        return this;
    }

    public String error() {
        return this.error;
    }

    public WebJobProperties withError(String error) {
        this.error = error;
        return this;
    }

    public Boolean usingSdk() {
        return this.usingSdk;
    }

    public WebJobProperties withUsingSdk(Boolean usingSdk) {
        this.usingSdk = usingSdk;
        return this;
    }

    public Map<String, Object> settings() {
        return this.settings;
    }

    public WebJobProperties withSettings(Map<String, Object> settings) {
        this.settings = settings;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("run_command", this.runCommand);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("extra_info_url", this.extraInfoUrl);
        jsonWriter.writeStringField("web_job_type", this.webJobType == null ? null : this.webJobType.toString());
        jsonWriter.writeStringField("error", this.error);
        jsonWriter.writeBooleanField("using_sdk", this.usingSdk);
        jsonWriter.writeMapField("settings", this.settings, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static WebJobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WebJobProperties)jsonReader.readObject(reader -> {
            WebJobProperties deserializedWebJobProperties = new WebJobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("run_command".equals(fieldName)) {
                    deserializedWebJobProperties.runCommand = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedWebJobProperties.url = reader.getString();
                    continue;
                }
                if ("extra_info_url".equals(fieldName)) {
                    deserializedWebJobProperties.extraInfoUrl = reader.getString();
                    continue;
                }
                if ("web_job_type".equals(fieldName)) {
                    deserializedWebJobProperties.webJobType = WebJobType.fromString(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedWebJobProperties.error = reader.getString();
                    continue;
                }
                if ("using_sdk".equals(fieldName)) {
                    deserializedWebJobProperties.usingSdk = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("settings".equals(fieldName)) {
                    Map settings;
                    deserializedWebJobProperties.settings = settings = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebJobProperties;
        });
    }
}

