/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WebJobInner;
import java.io.IOException;
import java.util.List;

public final class WebJobCollection
implements JsonSerializable<WebJobCollection> {
    private List<WebJobInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(WebJobCollection.class);

    public List<WebJobInner> value() {
        return this.value;
    }

    public WebJobCollection withValue(List<WebJobInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model WebJobCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WebJobCollection fromJson(JsonReader jsonReader) throws IOException {
        return (WebJobCollection)jsonReader.readObject(reader -> {
            WebJobCollection deserializedWebJobCollection = new WebJobCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedWebJobCollection.value = value = reader.readArray(reader1 -> WebJobInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedWebJobCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebJobCollection;
        });
    }
}

