/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.LinuxJavaContainerSettings;
import com.azure.resourcemanager.appservice.models.WebAppRuntimeSettings;
import com.azure.resourcemanager.appservice.models.WindowsJavaContainerSettings;
import java.io.IOException;

public final class WebAppRuntimes
implements JsonSerializable<WebAppRuntimes> {
    private WebAppRuntimeSettings linuxRuntimeSettings;
    private WebAppRuntimeSettings windowsRuntimeSettings;
    private LinuxJavaContainerSettings linuxContainerSettings;
    private WindowsJavaContainerSettings windowsContainerSettings;

    public WebAppRuntimeSettings linuxRuntimeSettings() {
        return this.linuxRuntimeSettings;
    }

    public WebAppRuntimeSettings windowsRuntimeSettings() {
        return this.windowsRuntimeSettings;
    }

    public LinuxJavaContainerSettings linuxContainerSettings() {
        return this.linuxContainerSettings;
    }

    public WindowsJavaContainerSettings windowsContainerSettings() {
        return this.windowsContainerSettings;
    }

    public void validate() {
        if (this.linuxRuntimeSettings() != null) {
            this.linuxRuntimeSettings().validate();
        }
        if (this.windowsRuntimeSettings() != null) {
            this.windowsRuntimeSettings().validate();
        }
        if (this.linuxContainerSettings() != null) {
            this.linuxContainerSettings().validate();
        }
        if (this.windowsContainerSettings() != null) {
            this.windowsContainerSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static WebAppRuntimes fromJson(JsonReader jsonReader) throws IOException {
        return (WebAppRuntimes)jsonReader.readObject(reader -> {
            WebAppRuntimes deserializedWebAppRuntimes = new WebAppRuntimes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linuxRuntimeSettings".equals(fieldName)) {
                    deserializedWebAppRuntimes.linuxRuntimeSettings = WebAppRuntimeSettings.fromJson(reader);
                    continue;
                }
                if ("windowsRuntimeSettings".equals(fieldName)) {
                    deserializedWebAppRuntimes.windowsRuntimeSettings = WebAppRuntimeSettings.fromJson(reader);
                    continue;
                }
                if ("linuxContainerSettings".equals(fieldName)) {
                    deserializedWebAppRuntimes.linuxContainerSettings = LinuxJavaContainerSettings.fromJson(reader);
                    continue;
                }
                if ("windowsContainerSettings".equals(fieldName)) {
                    deserializedWebAppRuntimes.windowsContainerSettings = WindowsJavaContainerSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebAppRuntimes;
        });
    }
}

