/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.GitHubActionCodeConfiguration;
import com.azure.resourcemanager.appservice.models.GitHubActionContainerConfiguration;
import java.io.IOException;

public final class GitHubActionConfiguration
implements JsonSerializable<GitHubActionConfiguration> {
    private GitHubActionCodeConfiguration codeConfiguration;
    private GitHubActionContainerConfiguration containerConfiguration;
    private Boolean isLinux;
    private Boolean generateWorkflowFile;

    public GitHubActionCodeConfiguration codeConfiguration() {
        return this.codeConfiguration;
    }

    public GitHubActionConfiguration withCodeConfiguration(GitHubActionCodeConfiguration codeConfiguration) {
        this.codeConfiguration = codeConfiguration;
        return this;
    }

    public GitHubActionContainerConfiguration containerConfiguration() {
        return this.containerConfiguration;
    }

    public GitHubActionConfiguration withContainerConfiguration(GitHubActionContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        return this;
    }

    public Boolean isLinux() {
        return this.isLinux;
    }

    public GitHubActionConfiguration withIsLinux(Boolean isLinux) {
        this.isLinux = isLinux;
        return this;
    }

    public Boolean generateWorkflowFile() {
        return this.generateWorkflowFile;
    }

    public GitHubActionConfiguration withGenerateWorkflowFile(Boolean generateWorkflowFile) {
        this.generateWorkflowFile = generateWorkflowFile;
        return this;
    }

    public void validate() {
        if (this.codeConfiguration() != null) {
            this.codeConfiguration().validate();
        }
        if (this.containerConfiguration() != null) {
            this.containerConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("codeConfiguration", (JsonSerializable)this.codeConfiguration);
        jsonWriter.writeJsonField("containerConfiguration", (JsonSerializable)this.containerConfiguration);
        jsonWriter.writeBooleanField("isLinux", this.isLinux);
        jsonWriter.writeBooleanField("generateWorkflowFile", this.generateWorkflowFile);
        return jsonWriter.writeEndObject();
    }

    public static GitHubActionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (GitHubActionConfiguration)jsonReader.readObject(reader -> {
            GitHubActionConfiguration deserializedGitHubActionConfiguration = new GitHubActionConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("codeConfiguration".equals(fieldName)) {
                    deserializedGitHubActionConfiguration.codeConfiguration = GitHubActionCodeConfiguration.fromJson(reader);
                    continue;
                }
                if ("containerConfiguration".equals(fieldName)) {
                    deserializedGitHubActionConfiguration.containerConfiguration = GitHubActionContainerConfiguration.fromJson(reader);
                    continue;
                }
                if ("isLinux".equals(fieldName)) {
                    deserializedGitHubActionConfiguration.isLinux = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("generateWorkflowFile".equals(fieldName)) {
                    deserializedGitHubActionConfiguration.generateWorkflowFile = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGitHubActionConfiguration;
        });
    }
}

