/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ContainerCpuStatistics;
import com.azure.resourcemanager.appservice.models.ContainerMemoryStatistics;
import com.azure.resourcemanager.appservice.models.ContainerNetworkInterfaceStatistics;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ContainerInfo
implements JsonSerializable<ContainerInfo> {
    private OffsetDateTime currentTimestamp;
    private OffsetDateTime previousTimestamp;
    private ContainerCpuStatistics currentCpuStats;
    private ContainerCpuStatistics previousCpuStats;
    private ContainerMemoryStatistics memoryStats;
    private String name;
    private String id;
    private ContainerNetworkInterfaceStatistics eth0;

    public OffsetDateTime currentTimestamp() {
        return this.currentTimestamp;
    }

    public ContainerInfo withCurrentTimestamp(OffsetDateTime currentTimestamp) {
        this.currentTimestamp = currentTimestamp;
        return this;
    }

    public OffsetDateTime previousTimestamp() {
        return this.previousTimestamp;
    }

    public ContainerInfo withPreviousTimestamp(OffsetDateTime previousTimestamp) {
        this.previousTimestamp = previousTimestamp;
        return this;
    }

    public ContainerCpuStatistics currentCpuStats() {
        return this.currentCpuStats;
    }

    public ContainerInfo withCurrentCpuStats(ContainerCpuStatistics currentCpuStats) {
        this.currentCpuStats = currentCpuStats;
        return this;
    }

    public ContainerCpuStatistics previousCpuStats() {
        return this.previousCpuStats;
    }

    public ContainerInfo withPreviousCpuStats(ContainerCpuStatistics previousCpuStats) {
        this.previousCpuStats = previousCpuStats;
        return this;
    }

    public ContainerMemoryStatistics memoryStats() {
        return this.memoryStats;
    }

    public ContainerInfo withMemoryStats(ContainerMemoryStatistics memoryStats) {
        this.memoryStats = memoryStats;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ContainerInfo withName(String name) {
        this.name = name;
        return this;
    }

    public String id() {
        return this.id;
    }

    public ContainerInfo withId(String id) {
        this.id = id;
        return this;
    }

    public ContainerNetworkInterfaceStatistics eth0() {
        return this.eth0;
    }

    public ContainerInfo withEth0(ContainerNetworkInterfaceStatistics eth0) {
        this.eth0 = eth0;
        return this;
    }

    public void validate() {
        if (this.currentCpuStats() != null) {
            this.currentCpuStats().validate();
        }
        if (this.previousCpuStats() != null) {
            this.previousCpuStats().validate();
        }
        if (this.memoryStats() != null) {
            this.memoryStats().validate();
        }
        if (this.eth0() != null) {
            this.eth0().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("currentTimeStamp", this.currentTimestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.currentTimestamp));
        jsonWriter.writeStringField("previousTimeStamp", this.previousTimestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.previousTimestamp));
        jsonWriter.writeJsonField("currentCpuStats", (JsonSerializable)this.currentCpuStats);
        jsonWriter.writeJsonField("previousCpuStats", (JsonSerializable)this.previousCpuStats);
        jsonWriter.writeJsonField("memoryStats", (JsonSerializable)this.memoryStats);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("eth0", (JsonSerializable)this.eth0);
        return jsonWriter.writeEndObject();
    }

    public static ContainerInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerInfo)jsonReader.readObject(reader -> {
            ContainerInfo deserializedContainerInfo = new ContainerInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("currentTimeStamp".equals(fieldName)) {
                    deserializedContainerInfo.currentTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("previousTimeStamp".equals(fieldName)) {
                    deserializedContainerInfo.previousTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("currentCpuStats".equals(fieldName)) {
                    deserializedContainerInfo.currentCpuStats = ContainerCpuStatistics.fromJson(reader);
                    continue;
                }
                if ("previousCpuStats".equals(fieldName)) {
                    deserializedContainerInfo.previousCpuStats = ContainerCpuStatistics.fromJson(reader);
                    continue;
                }
                if ("memoryStats".equals(fieldName)) {
                    deserializedContainerInfo.memoryStats = ContainerMemoryStatistics.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedContainerInfo.name = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedContainerInfo.id = reader.getString();
                    continue;
                }
                if ("eth0".equals(fieldName)) {
                    deserializedContainerInfo.eth0 = ContainerNetworkInterfaceStatistics.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerInfo;
        });
    }
}

