/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.StaticSite;
import com.azure.resourcemanager.appservice.models.DatabaseConnectionOverview;
import com.azure.resourcemanager.appservice.models.EnterpriseGradeCdnStatus;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.ResponseMessageEnvelopeRemotePrivateEndpointConnection;
import com.azure.resourcemanager.appservice.models.SkuDescription;
import com.azure.resourcemanager.appservice.models.StagingEnvironmentPolicy;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildProperties;
import com.azure.resourcemanager.appservice.models.StaticSiteLinkedBackend;
import com.azure.resourcemanager.appservice.models.StaticSiteTemplateOptions;
import com.azure.resourcemanager.appservice.models.StaticSiteUserProvidedFunctionApp;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class StaticSiteArmResourceInner
extends Resource {
    private StaticSite innerProperties;
    private SkuDescription sku;
    private ManagedServiceIdentity identity;
    private String kind;
    private String type;
    private String name;
    private String id;

    private StaticSite innerProperties() {
        return this.innerProperties;
    }

    public SkuDescription sku() {
        return this.sku;
    }

    public StaticSiteArmResourceInner withSku(SkuDescription sku) {
        this.sku = sku;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public StaticSiteArmResourceInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public StaticSiteArmResourceInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public StaticSiteArmResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public StaticSiteArmResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String defaultHostname() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultHostname();
    }

    public String repositoryUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().repositoryUrl();
    }

    public StaticSiteArmResourceInner withRepositoryUrl(String repositoryUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withRepositoryUrl(repositoryUrl);
        return this;
    }

    public String branch() {
        return this.innerProperties() == null ? null : this.innerProperties().branch();
    }

    public StaticSiteArmResourceInner withBranch(String branch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withBranch(branch);
        return this;
    }

    public List<String> customDomains() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomains();
    }

    public String repositoryToken() {
        return this.innerProperties() == null ? null : this.innerProperties().repositoryToken();
    }

    public StaticSiteArmResourceInner withRepositoryToken(String repositoryToken) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withRepositoryToken(repositoryToken);
        return this;
    }

    public StaticSiteBuildProperties buildProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().buildProperties();
    }

    public StaticSiteArmResourceInner withBuildProperties(StaticSiteBuildProperties buildProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withBuildProperties(buildProperties);
        return this;
    }

    public List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public StagingEnvironmentPolicy stagingEnvironmentPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().stagingEnvironmentPolicy();
    }

    public StaticSiteArmResourceInner withStagingEnvironmentPolicy(StagingEnvironmentPolicy stagingEnvironmentPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withStagingEnvironmentPolicy(stagingEnvironmentPolicy);
        return this;
    }

    public Boolean allowConfigFileUpdates() {
        return this.innerProperties() == null ? null : this.innerProperties().allowConfigFileUpdates();
    }

    public StaticSiteArmResourceInner withAllowConfigFileUpdates(Boolean allowConfigFileUpdates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withAllowConfigFileUpdates(allowConfigFileUpdates);
        return this;
    }

    public StaticSiteTemplateOptions templateProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().templateProperties();
    }

    public StaticSiteArmResourceInner withTemplateProperties(StaticSiteTemplateOptions templateProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withTemplateProperties(templateProperties);
        return this;
    }

    public String contentDistributionEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().contentDistributionEndpoint();
    }

    public String keyVaultReferenceIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultReferenceIdentity();
    }

    public List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps() {
        return this.innerProperties() == null ? null : this.innerProperties().userProvidedFunctionApps();
    }

    public List<StaticSiteLinkedBackend> linkedBackends() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedBackends();
    }

    public String provider() {
        return this.innerProperties() == null ? null : this.innerProperties().provider();
    }

    public StaticSiteArmResourceInner withProvider(String provider) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withProvider(provider);
        return this;
    }

    public EnterpriseGradeCdnStatus enterpriseGradeCdnStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().enterpriseGradeCdnStatus();
    }

    public StaticSiteArmResourceInner withEnterpriseGradeCdnStatus(EnterpriseGradeCdnStatus enterpriseGradeCdnStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withEnterpriseGradeCdnStatus(enterpriseGradeCdnStatus);
        return this;
    }

    public String publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public StaticSiteArmResourceInner withPublicNetworkAccess(String publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public List<DatabaseConnectionOverview> databaseConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseConnections();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    public static StaticSiteArmResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (StaticSiteArmResourceInner)((Object)jsonReader.readObject(reader -> {
            StaticSiteArmResourceInner deserializedStaticSiteArmResourceInner = new StaticSiteArmResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedStaticSiteArmResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedStaticSiteArmResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStaticSiteArmResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedStaticSiteArmResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedStaticSiteArmResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStaticSiteArmResourceInner.innerProperties = StaticSite.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedStaticSiteArmResourceInner.sku = SkuDescription.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedStaticSiteArmResourceInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedStaticSiteArmResourceInner.kind = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStaticSiteArmResourceInner;
        }));
    }
}

