/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ArmIdWrapper;
import com.azure.resourcemanager.appservice.models.PrivateLinkConnectionState;
import java.io.IOException;
import java.util.List;

public final class RemotePrivateEndpointConnectionProperties
implements JsonSerializable<RemotePrivateEndpointConnectionProperties> {
    private String provisioningState;
    private ArmIdWrapper privateEndpoint;
    private PrivateLinkConnectionState privateLinkServiceConnectionState;
    private List<String> ipAddresses;

    public String provisioningState() {
        return this.provisioningState;
    }

    public ArmIdWrapper privateEndpoint() {
        return this.privateEndpoint;
    }

    public RemotePrivateEndpointConnectionProperties withPrivateEndpoint(ArmIdWrapper privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public PrivateLinkConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public RemotePrivateEndpointConnectionProperties withPrivateLinkServiceConnectionState(PrivateLinkConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public List<String> ipAddresses() {
        return this.ipAddresses;
    }

    public RemotePrivateEndpointConnectionProperties withIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateEndpoint", (JsonSerializable)this.privateEndpoint);
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", (JsonSerializable)this.privateLinkServiceConnectionState);
        jsonWriter.writeArrayField("ipAddresses", this.ipAddresses, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static RemotePrivateEndpointConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RemotePrivateEndpointConnectionProperties)jsonReader.readObject(reader -> {
            RemotePrivateEndpointConnectionProperties deserializedRemotePrivateEndpointConnectionProperties = new RemotePrivateEndpointConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnectionProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("privateEndpoint".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnectionProperties.privateEndpoint = ArmIdWrapper.fromJson(reader);
                    continue;
                }
                if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnectionProperties.privateLinkServiceConnectionState = PrivateLinkConnectionState.fromJson(reader);
                    continue;
                }
                if ("ipAddresses".equals(fieldName)) {
                    List ipAddresses;
                    deserializedRemotePrivateEndpointConnectionProperties.ipAddresses = ipAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRemotePrivateEndpointConnectionProperties;
        });
    }
}

