/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.CookieExpiration;
import com.azure.resourcemanager.appservice.models.LoginRoutes;
import com.azure.resourcemanager.appservice.models.Nonce;
import com.azure.resourcemanager.appservice.models.TokenStore;
import java.io.IOException;
import java.util.List;

public final class Login
implements JsonSerializable<Login> {
    private LoginRoutes routes;
    private TokenStore tokenStore;
    private Boolean preserveUrlFragmentsForLogins;
    private List<String> allowedExternalRedirectUrls;
    private CookieExpiration cookieExpiration;
    private Nonce nonce;

    public LoginRoutes routes() {
        return this.routes;
    }

    public Login withRoutes(LoginRoutes routes) {
        this.routes = routes;
        return this;
    }

    public TokenStore tokenStore() {
        return this.tokenStore;
    }

    public Login withTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
        return this;
    }

    public Boolean preserveUrlFragmentsForLogins() {
        return this.preserveUrlFragmentsForLogins;
    }

    public Login withPreserveUrlFragmentsForLogins(Boolean preserveUrlFragmentsForLogins) {
        this.preserveUrlFragmentsForLogins = preserveUrlFragmentsForLogins;
        return this;
    }

    public List<String> allowedExternalRedirectUrls() {
        return this.allowedExternalRedirectUrls;
    }

    public Login withAllowedExternalRedirectUrls(List<String> allowedExternalRedirectUrls) {
        this.allowedExternalRedirectUrls = allowedExternalRedirectUrls;
        return this;
    }

    public CookieExpiration cookieExpiration() {
        return this.cookieExpiration;
    }

    public Login withCookieExpiration(CookieExpiration cookieExpiration) {
        this.cookieExpiration = cookieExpiration;
        return this;
    }

    public Nonce nonce() {
        return this.nonce;
    }

    public Login withNonce(Nonce nonce) {
        this.nonce = nonce;
        return this;
    }

    public void validate() {
        if (this.routes() != null) {
            this.routes().validate();
        }
        if (this.tokenStore() != null) {
            this.tokenStore().validate();
        }
        if (this.cookieExpiration() != null) {
            this.cookieExpiration().validate();
        }
        if (this.nonce() != null) {
            this.nonce().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("routes", (JsonSerializable)this.routes);
        jsonWriter.writeJsonField("tokenStore", (JsonSerializable)this.tokenStore);
        jsonWriter.writeBooleanField("preserveUrlFragmentsForLogins", this.preserveUrlFragmentsForLogins);
        jsonWriter.writeArrayField("allowedExternalRedirectUrls", this.allowedExternalRedirectUrls, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("cookieExpiration", (JsonSerializable)this.cookieExpiration);
        jsonWriter.writeJsonField("nonce", (JsonSerializable)this.nonce);
        return jsonWriter.writeEndObject();
    }

    public static Login fromJson(JsonReader jsonReader) throws IOException {
        return (Login)jsonReader.readObject(reader -> {
            Login deserializedLogin = new Login();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("routes".equals(fieldName)) {
                    deserializedLogin.routes = LoginRoutes.fromJson(reader);
                    continue;
                }
                if ("tokenStore".equals(fieldName)) {
                    deserializedLogin.tokenStore = TokenStore.fromJson(reader);
                    continue;
                }
                if ("preserveUrlFragmentsForLogins".equals(fieldName)) {
                    deserializedLogin.preserveUrlFragmentsForLogins = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowedExternalRedirectUrls".equals(fieldName)) {
                    List allowedExternalRedirectUrls;
                    deserializedLogin.allowedExternalRedirectUrls = allowedExternalRedirectUrls = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("cookieExpiration".equals(fieldName)) {
                    deserializedLogin.cookieExpiration = CookieExpiration.fromJson(reader);
                    continue;
                }
                if ("nonce".equals(fieldName)) {
                    deserializedLogin.nonce = Nonce.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogin;
        });
    }
}

