/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AllowedAudiencesValidation;
import com.azure.resourcemanager.appservice.models.ClientRegistration;
import com.azure.resourcemanager.appservice.models.LoginScopes;
import java.io.IOException;

public final class LegacyMicrosoftAccount
implements JsonSerializable<LegacyMicrosoftAccount> {
    private Boolean enabled;
    private ClientRegistration registration;
    private LoginScopes login;
    private AllowedAudiencesValidation validation;

    public Boolean enabled() {
        return this.enabled;
    }

    public LegacyMicrosoftAccount withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ClientRegistration registration() {
        return this.registration;
    }

    public LegacyMicrosoftAccount withRegistration(ClientRegistration registration) {
        this.registration = registration;
        return this;
    }

    public LoginScopes login() {
        return this.login;
    }

    public LegacyMicrosoftAccount withLogin(LoginScopes login) {
        this.login = login;
        return this;
    }

    public AllowedAudiencesValidation validation() {
        return this.validation;
    }

    public LegacyMicrosoftAccount withValidation(AllowedAudiencesValidation validation) {
        this.validation = validation;
        return this;
    }

    public void validate() {
        if (this.registration() != null) {
            this.registration().validate();
        }
        if (this.login() != null) {
            this.login().validate();
        }
        if (this.validation() != null) {
            this.validation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("registration", (JsonSerializable)this.registration);
        jsonWriter.writeJsonField("login", (JsonSerializable)this.login);
        jsonWriter.writeJsonField("validation", (JsonSerializable)this.validation);
        return jsonWriter.writeEndObject();
    }

    public static LegacyMicrosoftAccount fromJson(JsonReader jsonReader) throws IOException {
        return (LegacyMicrosoftAccount)jsonReader.readObject(reader -> {
            LegacyMicrosoftAccount deserializedLegacyMicrosoftAccount = new LegacyMicrosoftAccount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedLegacyMicrosoftAccount.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("registration".equals(fieldName)) {
                    deserializedLegacyMicrosoftAccount.registration = ClientRegistration.fromJson(reader);
                    continue;
                }
                if ("login".equals(fieldName)) {
                    deserializedLegacyMicrosoftAccount.login = LoginScopes.fromJson(reader);
                    continue;
                }
                if ("validation".equals(fieldName)) {
                    deserializedLegacyMicrosoftAccount.validation = AllowedAudiencesValidation.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLegacyMicrosoftAccount;
        });
    }
}

