/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.BackupItemInner;
import java.io.IOException;
import java.util.List;

public final class BackupItemCollection
implements JsonSerializable<BackupItemCollection> {
    private List<BackupItemInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(BackupItemCollection.class);

    public List<BackupItemInner> value() {
        return this.value;
    }

    public BackupItemCollection withValue(List<BackupItemInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model BackupItemCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BackupItemCollection fromJson(JsonReader jsonReader) throws IOException {
        return (BackupItemCollection)jsonReader.readObject(reader -> {
            BackupItemCollection deserializedBackupItemCollection = new BackupItemCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedBackupItemCollection.value = value = reader.readArray(reader1 -> BackupItemInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedBackupItemCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupItemCollection;
        });
    }
}

