/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.LogLevel;
import java.io.IOException;

public final class AzureBlobStorageApplicationLogsConfig
implements JsonSerializable<AzureBlobStorageApplicationLogsConfig> {
    private LogLevel level;
    private String sasUrl;
    private Integer retentionInDays;

    public LogLevel level() {
        return this.level;
    }

    public AzureBlobStorageApplicationLogsConfig withLevel(LogLevel level) {
        this.level = level;
        return this;
    }

    public String sasUrl() {
        return this.sasUrl;
    }

    public AzureBlobStorageApplicationLogsConfig withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    public AzureBlobStorageApplicationLogsConfig withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        jsonWriter.writeStringField("sasUrl", this.sasUrl);
        jsonWriter.writeNumberField("retentionInDays", (Number)this.retentionInDays);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobStorageApplicationLogsConfig fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobStorageApplicationLogsConfig)jsonReader.readObject(reader -> {
            AzureBlobStorageApplicationLogsConfig deserializedAzureBlobStorageApplicationLogsConfig = new AzureBlobStorageApplicationLogsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("level".equals(fieldName)) {
                    deserializedAzureBlobStorageApplicationLogsConfig.level = LogLevel.fromString(reader.getString());
                    continue;
                }
                if ("sasUrl".equals(fieldName)) {
                    deserializedAzureBlobStorageApplicationLogsConfig.sasUrl = reader.getString();
                    continue;
                }
                if ("retentionInDays".equals(fieldName)) {
                    deserializedAzureBlobStorageApplicationLogsConfig.retentionInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBlobStorageApplicationLogsConfig;
        });
    }
}

