/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AzureBlobStorageApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.AzureTableStorageApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.FileSystemApplicationLogsConfig;
import java.io.IOException;

public final class ApplicationLogsConfig
implements JsonSerializable<ApplicationLogsConfig> {
    private FileSystemApplicationLogsConfig fileSystem;
    private AzureTableStorageApplicationLogsConfig azureTableStorage;
    private AzureBlobStorageApplicationLogsConfig azureBlobStorage;

    public FileSystemApplicationLogsConfig fileSystem() {
        return this.fileSystem;
    }

    public ApplicationLogsConfig withFileSystem(FileSystemApplicationLogsConfig fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public AzureTableStorageApplicationLogsConfig azureTableStorage() {
        return this.azureTableStorage;
    }

    public ApplicationLogsConfig withAzureTableStorage(AzureTableStorageApplicationLogsConfig azureTableStorage) {
        this.azureTableStorage = azureTableStorage;
        return this;
    }

    public AzureBlobStorageApplicationLogsConfig azureBlobStorage() {
        return this.azureBlobStorage;
    }

    public ApplicationLogsConfig withAzureBlobStorage(AzureBlobStorageApplicationLogsConfig azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
        return this;
    }

    public void validate() {
        if (this.fileSystem() != null) {
            this.fileSystem().validate();
        }
        if (this.azureTableStorage() != null) {
            this.azureTableStorage().validate();
        }
        if (this.azureBlobStorage() != null) {
            this.azureBlobStorage().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("fileSystem", (JsonSerializable)this.fileSystem);
        jsonWriter.writeJsonField("azureTableStorage", (JsonSerializable)this.azureTableStorage);
        jsonWriter.writeJsonField("azureBlobStorage", (JsonSerializable)this.azureBlobStorage);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationLogsConfig fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationLogsConfig)jsonReader.readObject(reader -> {
            ApplicationLogsConfig deserializedApplicationLogsConfig = new ApplicationLogsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileSystem".equals(fieldName)) {
                    deserializedApplicationLogsConfig.fileSystem = FileSystemApplicationLogsConfig.fromJson(reader);
                    continue;
                }
                if ("azureTableStorage".equals(fieldName)) {
                    deserializedApplicationLogsConfig.azureTableStorage = AzureTableStorageApplicationLogsConfig.fromJson(reader);
                    continue;
                }
                if ("azureBlobStorage".equals(fieldName)) {
                    deserializedApplicationLogsConfig.azureBlobStorage = AzureBlobStorageApplicationLogsConfig.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationLogsConfig;
        });
    }
}

