/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.Channels;
import com.azure.resourcemanager.appservice.models.NotificationLevel;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class RecommendationRuleProperties
implements JsonSerializable<RecommendationRuleProperties> {
    private String recommendationName;
    private String displayName;
    private String message;
    private UUID recommendationId;
    private String description;
    private String actionName;
    private NotificationLevel level;
    private Channels channels;
    private List<String> categoryTags;
    private Boolean isDynamic;
    private String extensionName;
    private String bladeName;
    private String forwardLink;

    public String recommendationName() {
        return this.recommendationName;
    }

    public RecommendationRuleProperties withRecommendationName(String recommendationName) {
        this.recommendationName = recommendationName;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public RecommendationRuleProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String message() {
        return this.message;
    }

    public RecommendationRuleProperties withMessage(String message) {
        this.message = message;
        return this;
    }

    public UUID recommendationId() {
        return this.recommendationId;
    }

    public RecommendationRuleProperties withRecommendationId(UUID recommendationId) {
        this.recommendationId = recommendationId;
        return this;
    }

    public String description() {
        return this.description;
    }

    public RecommendationRuleProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String actionName() {
        return this.actionName;
    }

    public RecommendationRuleProperties withActionName(String actionName) {
        this.actionName = actionName;
        return this;
    }

    public NotificationLevel level() {
        return this.level;
    }

    public RecommendationRuleProperties withLevel(NotificationLevel level) {
        this.level = level;
        return this;
    }

    public Channels channels() {
        return this.channels;
    }

    public RecommendationRuleProperties withChannels(Channels channels) {
        this.channels = channels;
        return this;
    }

    public List<String> categoryTags() {
        return this.categoryTags;
    }

    public Boolean isDynamic() {
        return this.isDynamic;
    }

    public RecommendationRuleProperties withIsDynamic(Boolean isDynamic) {
        this.isDynamic = isDynamic;
        return this;
    }

    public String extensionName() {
        return this.extensionName;
    }

    public RecommendationRuleProperties withExtensionName(String extensionName) {
        this.extensionName = extensionName;
        return this;
    }

    public String bladeName() {
        return this.bladeName;
    }

    public RecommendationRuleProperties withBladeName(String bladeName) {
        this.bladeName = bladeName;
        return this;
    }

    public String forwardLink() {
        return this.forwardLink;
    }

    public RecommendationRuleProperties withForwardLink(String forwardLink) {
        this.forwardLink = forwardLink;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recommendationName", this.recommendationName);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("recommendationId", Objects.toString(this.recommendationId, null));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("actionName", this.actionName);
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        jsonWriter.writeStringField("channels", this.channels == null ? null : this.channels.toString());
        jsonWriter.writeBooleanField("isDynamic", this.isDynamic);
        jsonWriter.writeStringField("extensionName", this.extensionName);
        jsonWriter.writeStringField("bladeName", this.bladeName);
        jsonWriter.writeStringField("forwardLink", this.forwardLink);
        return jsonWriter.writeEndObject();
    }

    public static RecommendationRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RecommendationRuleProperties)jsonReader.readObject(reader -> {
            RecommendationRuleProperties deserializedRecommendationRuleProperties = new RecommendationRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recommendationName".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.recommendationName = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.displayName = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.message = reader.getString();
                    continue;
                }
                if ("recommendationId".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.recommendationId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.description = reader.getString();
                    continue;
                }
                if ("actionName".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.actionName = reader.getString();
                    continue;
                }
                if ("level".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.level = NotificationLevel.fromString(reader.getString());
                    continue;
                }
                if ("channels".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.channels = Channels.fromString(reader.getString());
                    continue;
                }
                if ("categoryTags".equals(fieldName)) {
                    List categoryTags;
                    deserializedRecommendationRuleProperties.categoryTags = categoryTags = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isDynamic".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.isDynamic = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("extensionName".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.extensionName = reader.getString();
                    continue;
                }
                if ("bladeName".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.bladeName = reader.getString();
                    continue;
                }
                if ("forwardLink".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.forwardLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecommendationRuleProperties;
        });
    }
}

