/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.SlotDifferenceInner;
import java.io.IOException;
import java.util.List;

public final class SlotDifferenceCollection
implements JsonSerializable<SlotDifferenceCollection> {
    private List<SlotDifferenceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SlotDifferenceCollection.class);

    public List<SlotDifferenceInner> value() {
        return this.value;
    }

    public SlotDifferenceCollection withValue(List<SlotDifferenceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SlotDifferenceCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SlotDifferenceCollection fromJson(JsonReader jsonReader) throws IOException {
        return (SlotDifferenceCollection)jsonReader.readObject(reader -> {
            SlotDifferenceCollection deserializedSlotDifferenceCollection = new SlotDifferenceCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSlotDifferenceCollection.value = value = reader.readArray(reader1 -> SlotDifferenceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSlotDifferenceCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSlotDifferenceCollection;
        });
    }
}

