/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.LogLevel;
import java.io.IOException;

public final class AzureTableStorageApplicationLogsConfig
implements JsonSerializable<AzureTableStorageApplicationLogsConfig> {
    private LogLevel level;
    private String sasUrl;
    private static final ClientLogger LOGGER = new ClientLogger(AzureTableStorageApplicationLogsConfig.class);

    public LogLevel level() {
        return this.level;
    }

    public AzureTableStorageApplicationLogsConfig withLevel(LogLevel level) {
        this.level = level;
        return this;
    }

    public String sasUrl() {
        return this.sasUrl;
    }

    public AzureTableStorageApplicationLogsConfig withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    public void validate() {
        if (this.sasUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sasUrl in model AzureTableStorageApplicationLogsConfig"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sasUrl", this.sasUrl);
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        return jsonWriter.writeEndObject();
    }

    public static AzureTableStorageApplicationLogsConfig fromJson(JsonReader jsonReader) throws IOException {
        return (AzureTableStorageApplicationLogsConfig)jsonReader.readObject(reader -> {
            AzureTableStorageApplicationLogsConfig deserializedAzureTableStorageApplicationLogsConfig = new AzureTableStorageApplicationLogsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sasUrl".equals(fieldName)) {
                    deserializedAzureTableStorageApplicationLogsConfig.sasUrl = reader.getString();
                    continue;
                }
                if ("level".equals(fieldName)) {
                    deserializedAzureTableStorageApplicationLogsConfig.level = LogLevel.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureTableStorageApplicationLogsConfig;
        });
    }
}

