/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.time.Duration;
import java.util.HashSet;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

class RetryUtils {
    RetryUtils() {
    }

    public static <T> Mono<T> backoffRetryForFunctionAppAca(Mono<T> asyncOperation) {
        return asyncOperation.retryWhen((Retry)RetryUtils.backoffRetry(409, 429));
    }

    private static RetryBackoffSpec backoffRetry(int ... statusCodes) {
        HashSet<Integer> statusCodeSet = new HashSet<Integer>();
        for (int statusCode : statusCodes) {
            statusCodeSet.add(statusCode);
        }
        return Retry.backoff((long)5L, (Duration)ResourceManagerUtils.InternalRuntimeContext.getDelayDuration((Duration)Duration.ofSeconds(10L))).onRetryExhaustedThrow((spec, signal) -> signal.failure());
    }
}

