/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.implementation.DeploymentSlotBaseImpl;
import com.azure.resourcemanager.appservice.implementation.HttpFluxBBResponse;
import com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.azure.resourcemanager.appservice.implementation.WebAppImpl;
import com.azure.resourcemanager.appservice.models.CsmDeploymentStatus;
import com.azure.resourcemanager.appservice.models.DeployOptions;
import com.azure.resourcemanager.appservice.models.DeployType;
import com.azure.resourcemanager.appservice.models.DeploymentSlot;
import com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.azure.resourcemanager.appservice.models.KuduDeploymentResult;
import com.azure.resourcemanager.appservice.models.WebApp;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DeploymentSlotImpl
extends DeploymentSlotBaseImpl<DeploymentSlot, DeploymentSlotImpl, WebAppImpl, DeploymentSlot.DefinitionStages.WithCreate, DeploymentSlotBase.Update<DeploymentSlot>>
implements DeploymentSlot,
DeploymentSlot.Definition {
    DeploymentSlotImpl(String name, SiteInner innerObject, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig, WebAppImpl parent) {
        super(name, innerObject, siteConfig, logConfig, parent);
    }

    @Override
    public DeploymentSlotImpl withConfigurationFromParent() {
        return this.withConfigurationFromWebApp((WebApp)this.parent());
    }

    @Override
    public DeploymentSlotImpl withConfigurationFromWebApp(WebApp webApp) {
        this.siteConfig = ((WebAppBaseImpl)((Object)webApp)).siteConfig;
        this.configurationSource = webApp;
        return this;
    }

    @Override
    public Mono<Void> warDeployAsync(File warFile) {
        return this.warDeployAsync(warFile, null);
    }

    @Override
    public void warDeploy(File warFile) {
        this.warDeployAsync(warFile).block();
    }

    @Override
    public Mono<Void> warDeployAsync(InputStream warFile, long length) {
        return this.warDeployAsync(warFile, length, null);
    }

    @Override
    public void warDeploy(InputStream warFile, long length) {
        this.warDeployAsync(warFile, length).block();
    }

    @Override
    public Mono<Void> warDeployAsync(File warFile, String appName) {
        try {
            return this.kuduClient.warDeployAsync(warFile, appName);
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public void warDeploy(File warFile, String appName) {
        this.warDeployAsync(warFile, appName).block();
    }

    @Override
    public Mono<Void> warDeployAsync(InputStream warFile, long length, String appName) {
        return this.kuduClient.warDeployAsync(warFile, length, appName);
    }

    @Override
    public void warDeploy(InputStream warFile, long length, String appName) {
        this.warDeployAsync(warFile, length, appName).block();
    }

    @Override
    public void zipDeploy(File zipFile) {
        this.zipDeployAsync(zipFile).block();
    }

    @Override
    public void zipDeploy(InputStream zipFile, long length) {
        this.zipDeployAsync(zipFile, length).block();
    }

    @Override
    public Mono<Void> zipDeployAsync(InputStream zipFile, long length) {
        return this.kuduClient.zipDeployAsync(zipFile, length).then(this.stopAsync()).then(this.startAsync());
    }

    @Override
    public Mono<Void> zipDeployAsync(File zipFile) {
        try {
            return this.kuduClient.zipDeployAsync(zipFile);
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public void deploy(DeployType type, File file) {
        this.deployAsync(type, file).block();
    }

    @Override
    public Mono<Void> deployAsync(DeployType type, File file) {
        return this.deployAsync(type, file, new DeployOptions());
    }

    @Override
    public void deploy(DeployType type, File file, DeployOptions deployOptions) {
        this.deployAsync(type, file, deployOptions).block();
    }

    @Override
    public Mono<Void> deployAsync(DeployType type, File file, DeployOptions deployOptions) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(file);
        if (deployOptions == null) {
            deployOptions = new DeployOptions();
        }
        try {
            return this.kuduClient.deployAsync(type, file, deployOptions.path(), deployOptions.restartSite(), deployOptions.cleanDeployment());
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public void deploy(DeployType type, InputStream file, long length) {
        this.deployAsync(type, file, length).block();
    }

    @Override
    public Mono<Void> deployAsync(DeployType type, InputStream file, long length) {
        return this.deployAsync(type, file, length, new DeployOptions());
    }

    @Override
    public void deploy(DeployType type, InputStream file, long length, DeployOptions deployOptions) {
        this.deployAsync(type, file, length, deployOptions).block();
    }

    @Override
    public Mono<Void> deployAsync(DeployType type, InputStream file, long length, DeployOptions deployOptions) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(file);
        if (deployOptions == null) {
            deployOptions = new DeployOptions();
        }
        return this.kuduClient.deployAsync(type, file, length, deployOptions.path(), deployOptions.restartSite(), deployOptions.cleanDeployment());
    }

    @Override
    public KuduDeploymentResult pushDeploy(DeployType type, File file, DeployOptions deployOptions) {
        return (KuduDeploymentResult)this.pushDeployAsync(type, file, deployOptions).block();
    }

    @Override
    public Mono<KuduDeploymentResult> pushDeployAsync(DeployType type, File file, DeployOptions deployOptions) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(file);
        if (deployOptions == null) {
            deployOptions = new DeployOptions();
        }
        try {
            return this.kuduClient.pushDeployAsync(type, file, deployOptions.path(), deployOptions.restartSite(), deployOptions.cleanDeployment(), deployOptions.trackDeployment());
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public CsmDeploymentStatus getDeploymentStatus(String deploymentId) {
        return (CsmDeploymentStatus)((Object)this.getDeploymentStatusAsync(deploymentId).block());
    }

    @Override
    public Mono<CsmDeploymentStatus> getDeploymentStatusAsync(String deploymentId) {
        SerializerAdapter serializerAdapter = SerializerFactory.createDefaultManagementSerializerAdapter();
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getSlotSiteDeploymentStatusSlotWithResponseAsync(this.resourceGroupName(), ((WebAppImpl)this.parent()).name(), this.name(), deploymentId).flatMap(fluxResponse -> {
            HttpFluxBBResponse response = new HttpFluxBBResponse((Response<Flux<ByteBuffer>>)fluxResponse);
            return response.getBodyAsString().flatMap(bodyString -> {
                CsmDeploymentStatus status;
                try {
                    status = (CsmDeploymentStatus)((Object)((Object)((Object)serializerAdapter.deserialize(bodyString, CsmDeploymentStatus.class, SerializerEncoding.JSON))));
                }
                catch (IOException e) {
                    return Mono.error((Throwable)new ManagementException("Deserialize failed for response body.", response));
                }
                return Mono.justOrEmpty((Object)((Object)status));
            }).doFinally(ignored -> response.close());
        });
    }
}

