/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.Container;
import com.azure.resourcemanager.appservice.models.Dapr;
import com.azure.resourcemanager.appservice.models.Scale;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Template {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Template.class);
    @JsonProperty(value="revisionSuffix")
    private String revisionSuffix;
    @JsonProperty(value="containers")
    private List<Container> containers;
    @JsonProperty(value="scale")
    private Scale scale;
    @JsonProperty(value="dapr")
    private Dapr dapr;

    public String revisionSuffix() {
        return this.revisionSuffix;
    }

    public Template withRevisionSuffix(String revisionSuffix) {
        this.revisionSuffix = revisionSuffix;
        return this;
    }

    public List<Container> containers() {
        return this.containers;
    }

    public Template withContainers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    public Scale scale() {
        return this.scale;
    }

    public Template withScale(Scale scale) {
        this.scale = scale;
        return this;
    }

    public Dapr dapr() {
        return this.dapr;
    }

    public Template withDapr(Dapr dapr) {
        this.dapr = dapr;
        return this;
    }

    public void validate() {
        if (this.containers() != null) {
            this.containers().forEach(e -> e.validate());
        }
        if (this.scale() != null) {
            this.scale().validate();
        }
        if (this.dapr() != null) {
            this.dapr().validate();
        }
    }
}

