/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.FrequencyUnit;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class BackupSchedule {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BackupSchedule.class);
    @JsonProperty(value="frequencyInterval", required=true)
    private int frequencyInterval;
    @JsonProperty(value="frequencyUnit", required=true)
    private FrequencyUnit frequencyUnit;
    @JsonProperty(value="keepAtLeastOneBackup", required=true)
    private boolean keepAtLeastOneBackup;
    @JsonProperty(value="retentionPeriodInDays", required=true)
    private int retentionPeriodInDays;
    @JsonProperty(value="startTime")
    private OffsetDateTime startTime;
    @JsonProperty(value="lastExecutionTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastExecutionTime;

    public int frequencyInterval() {
        return this.frequencyInterval;
    }

    public BackupSchedule withFrequencyInterval(int frequencyInterval) {
        this.frequencyInterval = frequencyInterval;
        return this;
    }

    public FrequencyUnit frequencyUnit() {
        return this.frequencyUnit;
    }

    public BackupSchedule withFrequencyUnit(FrequencyUnit frequencyUnit) {
        this.frequencyUnit = frequencyUnit;
        return this;
    }

    public boolean keepAtLeastOneBackup() {
        return this.keepAtLeastOneBackup;
    }

    public BackupSchedule withKeepAtLeastOneBackup(boolean keepAtLeastOneBackup) {
        this.keepAtLeastOneBackup = keepAtLeastOneBackup;
        return this;
    }

    public int retentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    public BackupSchedule withRetentionPeriodInDays(int retentionPeriodInDays) {
        this.retentionPeriodInDays = retentionPeriodInDays;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public BackupSchedule withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime lastExecutionTime() {
        return this.lastExecutionTime;
    }

    public void validate() {
        if (this.frequencyUnit() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property frequencyUnit in model BackupSchedule"));
        }
    }
}

