/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.WorkerPool;
import com.azure.resourcemanager.appservice.models.ComputeModeOptions;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.SkuDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class WorkerPoolResourceInner
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WorkerPoolResourceInner.class);
    @JsonProperty(value="properties")
    private WorkerPool innerProperties;
    @JsonProperty(value="sku")
    private SkuDescription sku;

    private WorkerPool innerProperties() {
        return this.innerProperties;
    }

    public SkuDescription sku() {
        return this.sku;
    }

    public WorkerPoolResourceInner withSku(SkuDescription sku) {
        this.sku = sku;
        return this;
    }

    @Override
    public WorkerPoolResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public Integer workerSizeId() {
        return this.innerProperties() == null ? null : this.innerProperties().workerSizeId();
    }

    public WorkerPoolResourceInner withWorkerSizeId(Integer workerSizeId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkerPool();
        }
        this.innerProperties().withWorkerSizeId(workerSizeId);
        return this;
    }

    public ComputeModeOptions computeMode() {
        return this.innerProperties() == null ? null : this.innerProperties().computeMode();
    }

    public WorkerPoolResourceInner withComputeMode(ComputeModeOptions computeMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkerPool();
        }
        this.innerProperties().withComputeMode(computeMode);
        return this;
    }

    public String workerSize() {
        return this.innerProperties() == null ? null : this.innerProperties().workerSize();
    }

    public WorkerPoolResourceInner withWorkerSize(String workerSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkerPool();
        }
        this.innerProperties().withWorkerSize(workerSize);
        return this;
    }

    public Integer workerCount() {
        return this.innerProperties() == null ? null : this.innerProperties().workerCount();
    }

    public WorkerPoolResourceInner withWorkerCount(Integer workerCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkerPool();
        }
        this.innerProperties().withWorkerCount(workerCount);
        return this;
    }

    public List<String> instanceNames() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceNames();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

