/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.ByteBufferMarkableInputStream;
import com.azure.storage.common.implementation.StorageSeekableByteChannel;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.models.FileLastWrittenMode;
import com.azure.storage.file.share.models.ShareFileUploadRangeOptions;
import com.azure.storage.file.share.models.ShareRequestConditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

class StorageSeekableByteChannelShareFileWriteBehavior
implements StorageSeekableByteChannel.WriteBehavior {
    private static final ClientLogger LOGGER = new ClientLogger(StorageSeekableByteChannelShareFileWriteBehavior.class);
    private final ShareFileClient client;
    private final ShareRequestConditions conditions;
    private final FileLastWrittenMode lastWrittenMode;
    private Long fileSize;

    StorageSeekableByteChannelShareFileWriteBehavior(ShareFileClient client, ShareRequestConditions conditions, FileLastWrittenMode lastWrittenMode) {
        this.client = Objects.requireNonNull(client, "'client' cannot be null.");
        this.conditions = conditions;
        this.lastWrittenMode = lastWrittenMode;
    }

    ShareFileClient getClient() {
        return this.client;
    }

    ShareRequestConditions getRequestConditions() {
        return this.conditions;
    }

    FileLastWrittenMode getLastWrittenMode() {
        return this.lastWrittenMode;
    }

    public void write(ByteBuffer src, long destOffset) throws IOException {
        ByteBufferMarkableInputStream uploadStream = new ByteBufferMarkableInputStream(src);
        this.client.uploadRangeWithResponse(new ShareFileUploadRangeOptions((InputStream)uploadStream, (long)src.remaining()).setOffset(destOffset).setRequestConditions(this.conditions).setLastWrittenMode(this.lastWrittenMode), null, null);
    }

    public void commit(long totalLength) {
    }

    public void assertCanSeek(long position) {
        if (this.fileSize == null) {
            this.fileSize = this.client.getProperties().getContentLength();
        }
        if (0L <= position && position <= this.fileSize) {
            return;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot seek beyond bounds of file."));
    }

    public void resize(long newSize) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Setting share file size not supported through SeekableByteChannel interface."));
    }
}

