/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.util;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.sas.BlobContainerSasPermission;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobSasServiceVersion;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import java.time.OffsetDateTime;
import java.util.Objects;

public class BlobSasImplUtil {
    private static final String SAS_BLOB_CONSTANT = "b";
    private static final String SAS_BLOB_SNAPSHOT_CONSTANT = "bs";
    private static final String SAS_BLOB_VERSION_CONSTANT = "bv";
    private static final String SAS_CONTAINER_CONSTANT = "c";
    private final ClientLogger logger = new ClientLogger(BlobSasImplUtil.class);
    private String version;
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String containerName;
    private String blobName;
    private String resource;
    private String snapshotId;
    private String versionId;
    private String identifier;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;

    public BlobSasImplUtil(BlobServiceSasSignatureValues sasValues, String containerName) {
        this(sasValues, containerName, null, null, null);
    }

    public BlobSasImplUtil(BlobServiceSasSignatureValues sasValues, String containerName, String blobName, String snapshotId, String versionId) {
        Objects.requireNonNull(sasValues);
        if (snapshotId != null && versionId != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'snapshot' and 'versionId' cannot be used at the same time."));
        }
        this.version = null;
        this.protocol = sasValues.getProtocol();
        this.startTime = sasValues.getStartTime();
        this.expiryTime = sasValues.getExpiryTime();
        this.permissions = sasValues.getPermissions();
        this.sasIpRange = sasValues.getSasIpRange();
        this.containerName = containerName;
        this.blobName = blobName;
        this.snapshotId = snapshotId;
        this.versionId = versionId;
        this.identifier = sasValues.getIdentifier();
        this.cacheControl = sasValues.getCacheControl();
        this.contentDisposition = sasValues.getContentDisposition();
        this.contentEncoding = sasValues.getContentEncoding();
        this.contentLanguage = sasValues.getContentLanguage();
        this.contentType = sasValues.getContentType();
    }

    public String generateSas(StorageSharedKeyCredential storageSharedKeyCredentials) {
        StorageImplUtils.assertNotNull((String)"storageSharedKeyCredentials", (Object)storageSharedKeyCredentials);
        this.ensureState();
        String canonicalName = this.getCanonicalName(storageSharedKeyCredentials.getAccountName());
        String signature = storageSharedKeyCredentials.computeHmac256(this.stringToSign(canonicalName));
        return this.encode(null, signature);
    }

    public String generateUserDelegationSas(UserDelegationKey delegationKey, String accountName) {
        StorageImplUtils.assertNotNull((String)"delegationKey", (Object)delegationKey);
        StorageImplUtils.assertNotNull((String)"accountName", (Object)accountName);
        this.ensureState();
        String canonicalName = this.getCanonicalName(accountName);
        String signature = StorageImplUtils.computeHMac256((String)delegationKey.getValue(), (String)this.stringToSign(delegationKey, canonicalName));
        return this.encode(delegationKey, signature);
    }

    private String encode(UserDelegationKey userDelegationKey, String signature) {
        StringBuilder sb = new StringBuilder();
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sv", (Object)this.version);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"spr", (Object)this.protocol);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"st", (Object)SasImplUtils.formatQueryParameterDate((OffsetDateTime)this.startTime));
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"se", (Object)SasImplUtils.formatQueryParameterDate((OffsetDateTime)this.expiryTime));
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sip", (Object)this.sasIpRange);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"si", (Object)this.identifier);
        if (userDelegationKey != null) {
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"skoid", (Object)userDelegationKey.getSignedObjectId());
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sktid", (Object)userDelegationKey.getSignedTenantId());
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"skt", (Object)SasImplUtils.formatQueryParameterDate((OffsetDateTime)userDelegationKey.getSignedStart()));
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"ske", (Object)SasImplUtils.formatQueryParameterDate((OffsetDateTime)userDelegationKey.getSignedExpiry()));
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sks", (Object)userDelegationKey.getSignedService());
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"skv", (Object)userDelegationKey.getSignedVersion());
        }
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sr", (Object)this.resource);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sp", (Object)this.permissions);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sig", (Object)signature);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rscc", (Object)this.cacheControl);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rscd", (Object)this.contentDisposition);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rsce", (Object)this.contentEncoding);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rscl", (Object)this.contentLanguage);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rsct", (Object)this.contentType);
        return sb.toString();
    }

    private void ensureState() {
        if (this.version == null) {
            this.version = BlobSasServiceVersion.getLatest().getVersion();
        }
        if (this.identifier == null && (this.expiryTime == null || this.permissions == null)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("If identifier is not set, expiry time and permissions must be set"));
        }
        this.resource = CoreUtils.isNullOrEmpty((CharSequence)this.blobName) ? SAS_CONTAINER_CONSTANT : (this.snapshotId != null ? SAS_BLOB_SNAPSHOT_CONSTANT : (this.versionId != null ? SAS_BLOB_VERSION_CONSTANT : SAS_BLOB_CONSTANT));
        if (this.permissions != null) {
            switch (this.resource) {
                case "b": 
                case "bs": 
                case "bv": {
                    this.permissions = BlobSasPermission.parse(this.permissions).toString();
                    break;
                }
                case "c": {
                    this.permissions = BlobContainerSasPermission.parse(this.permissions).toString();
                    break;
                }
                default: {
                    this.logger.info("Not re-parsing permissions. Resource type '{}' is unknown.", new Object[]{this.resource});
                }
            }
        }
    }

    private String getCanonicalName(String account) {
        return CoreUtils.isNullOrEmpty((CharSequence)this.blobName) ? String.format("/blob/%s/%s", account, this.containerName) : String.format("/blob/%s/%s/%s", account, this.containerName, this.blobName.replace("\\", "/"));
    }

    private String stringToSign(String canonicalName) {
        String versionSegment = this.snapshotId == null ? this.versionId : this.snapshotId;
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, this.identifier == null ? "" : this.identifier, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version, this.resource, versionSegment == null ? "" : versionSegment, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }

    private String stringToSign(UserDelegationKey key, String canonicalName) {
        String versionSegment = this.snapshotId == null ? this.versionId : this.snapshotId;
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, key.getSignedObjectId() == null ? "" : key.getSignedObjectId(), key.getSignedTenantId() == null ? "" : key.getSignedTenantId(), key.getSignedStart() == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(key.getSignedStart()), key.getSignedExpiry() == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(key.getSignedExpiry()), key.getSignedService() == null ? "" : key.getSignedService(), key.getSignedVersion() == null ? "" : key.getSignedVersion(), "", "", "", this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version, this.resource, versionSegment == null ? "" : versionSegment, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }
}

