/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.util;

import com.azure.core.http.RequestConditions;
import com.azure.storage.blob.implementation.models.BlobDownloadHeaders;
import com.azure.storage.blob.implementation.models.BlobItemInternal;
import com.azure.storage.blob.implementation.models.BlobItemPropertiesInternal;
import com.azure.storage.blob.implementation.models.BlobTag;
import com.azure.storage.blob.models.BlobBeginCopySourceRequestConditions;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobItemProperties;
import com.azure.storage.blob.models.BlobLeaseRequestConditions;
import com.azure.storage.blob.models.ObjectReplicationPolicy;
import com.azure.storage.blob.models.ObjectReplicationRule;
import com.azure.storage.blob.models.ObjectReplicationStatus;
import com.azure.storage.blob.models.PageBlobCopyIncrementalRequestConditions;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.ProgressReceiver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelHelper {
    private static final long BLOB_DEFAULT_MAX_SINGLE_UPLOAD_SIZE = 0x10000000L;

    public static boolean determineAuthorityIsIpStyle(String authority) throws MalformedURLException {
        return new URL("http://" + authority).getPort() != -1;
    }

    public static com.azure.storage.blob.models.ParallelTransferOptions populateAndApplyDefaults(com.azure.storage.blob.models.ParallelTransferOptions other) {
        Long maxSingleUploadSize;
        Integer maxConcurrency;
        Long blockSize = (other = other == null ? new com.azure.storage.blob.models.ParallelTransferOptions() : other).getBlockSizeLong();
        if (blockSize == null) {
            blockSize = 0x400000L;
        }
        if ((maxConcurrency = other.getMaxConcurrency()) == null) {
            maxConcurrency = 8;
        }
        if ((maxSingleUploadSize = other.getMaxSingleUploadSizeLong()) == null) {
            maxSingleUploadSize = 0x10000000L;
        }
        return new com.azure.storage.blob.models.ParallelTransferOptions().setBlockSizeLong(blockSize).setMaxConcurrency(maxConcurrency).setProgressReceiver(other.getProgressReceiver()).setMaxSingleUploadSizeLong(maxSingleUploadSize);
    }

    public static ParallelTransferOptions wrapBlobOptions(com.azure.storage.blob.models.ParallelTransferOptions blobOptions) {
        Long blockSize = blobOptions.getBlockSizeLong();
        Integer maxConcurrency = blobOptions.getMaxConcurrency();
        ProgressReceiver wrappedReceiver = blobOptions.getProgressReceiver() == null ? null : blobOptions.getProgressReceiver()::reportProgress;
        Long maxSingleUploadSize = blobOptions.getMaxSingleUploadSizeLong();
        return new ParallelTransferOptions().setBlockSizeLong(blockSize).setMaxConcurrency(maxConcurrency).setProgressReceiver(wrappedReceiver).setMaxSingleUploadSizeLong(maxSingleUploadSize);
    }

    public static com.azure.storage.blob.models.BlobDownloadHeaders populateBlobDownloadHeaders(BlobDownloadHeaders internalHeaders) {
        com.azure.storage.blob.models.BlobDownloadHeaders headers = new com.azure.storage.blob.models.BlobDownloadHeaders();
        headers.setLastModified(internalHeaders.getLastModified());
        headers.setMetadata(internalHeaders.getMetadata());
        headers.setETag(internalHeaders.getETag());
        headers.setContentLength(internalHeaders.getContentLength());
        headers.setContentType(internalHeaders.getContentType());
        headers.setContentRange(internalHeaders.getContentRange());
        headers.setContentEncoding(internalHeaders.getContentEncoding());
        headers.setContentLanguage(internalHeaders.getContentLanguage());
        headers.setContentMd5(internalHeaders.getContentMd5());
        headers.setContentDisposition(internalHeaders.getContentDisposition());
        headers.setCacheControl(internalHeaders.getCacheControl());
        headers.setBlobSequenceNumber(internalHeaders.getBlobSequenceNumber());
        headers.setBlobType(internalHeaders.getBlobType());
        headers.setLeaseStatus(internalHeaders.getLeaseStatus());
        headers.setLeaseState(internalHeaders.getLeaseState());
        headers.setLeaseDuration(internalHeaders.getLeaseDuration());
        headers.setCopyId(internalHeaders.getCopyId());
        headers.setCopyStatus(internalHeaders.getCopyStatus());
        headers.setCopySource(internalHeaders.getCopySource());
        headers.setCopyProgress(internalHeaders.getCopyProgress());
        headers.setCopyCompletionTime(internalHeaders.getCopyCompletionTime());
        headers.setCopyStatusDescription(internalHeaders.getCopyStatusDescription());
        headers.setIsServerEncrypted(internalHeaders.isServerEncrypted());
        headers.setClientRequestId(internalHeaders.getClientRequestId());
        headers.setRequestId(internalHeaders.getRequestId());
        headers.setVersion(internalHeaders.getVersion());
        headers.setVersionId(internalHeaders.getVersionId());
        headers.setAcceptRanges(internalHeaders.getAcceptRanges());
        headers.setDateProperty(internalHeaders.getDateProperty());
        headers.setBlobCommittedBlockCount(internalHeaders.getBlobCommittedBlockCount());
        headers.setEncryptionKeySha256(internalHeaders.getEncryptionKeySha256());
        headers.setEncryptionScope(internalHeaders.getEncryptionScope());
        headers.setBlobContentMD5(internalHeaders.getBlobContentMD5());
        headers.setContentCrc64(internalHeaders.getContentCrc64());
        headers.setErrorCode(internalHeaders.getErrorCode());
        headers.setTagCount(internalHeaders.getTagCount());
        HashMap objectReplicationStatus = internalHeaders.getObjectReplicationRules();
        HashMap internalSourcePolicies = new HashMap();
        objectReplicationStatus = objectReplicationStatus == null ? new HashMap() : objectReplicationStatus;
        headers.setObjectReplicationDestinationPolicyId(objectReplicationStatus.getOrDefault("policy-id", null));
        if (headers.getObjectReplicationDestinationPolicyId() == null) {
            for (Map.Entry entry : objectReplicationStatus.entrySet()) {
                String[] split = ((String)entry.getKey()).split("_");
                String policyId = split[0];
                String ruleId = split[1];
                ObjectReplicationRule rule = new ObjectReplicationRule(ruleId, ObjectReplicationStatus.fromString((String)entry.getValue()));
                if (!internalSourcePolicies.containsKey(policyId)) {
                    internalSourcePolicies.put(policyId, new ArrayList());
                }
                ((List)internalSourcePolicies.get(policyId)).add(rule);
            }
        }
        ArrayList<ObjectReplicationPolicy> objectReplicationSourcePolicies = new ArrayList<ObjectReplicationPolicy>();
        for (Map.Entry entry : internalSourcePolicies.entrySet()) {
            objectReplicationSourcePolicies.add(new ObjectReplicationPolicy((String)entry.getKey(), (List)entry.getValue()));
        }
        headers.setObjectReplicationSourcePolicies(objectReplicationSourcePolicies);
        headers.setSealed(internalHeaders.isSealed());
        return headers;
    }

    public static BlobItem populateBlobItem(BlobItemInternal blobItemInternal) {
        BlobItem blobItem = new BlobItem();
        blobItem.setName(blobItemInternal.getName());
        blobItem.setDeleted(blobItemInternal.isDeleted());
        blobItem.setSnapshot(blobItemInternal.getSnapshot());
        blobItem.setProperties(ModelHelper.populateBlobItemProperties(blobItemInternal.getProperties()));
        blobItem.setMetadata(blobItemInternal.getMetadata());
        blobItem.setVersionId(blobItemInternal.getVersionId());
        blobItem.setCurrentVersion(blobItemInternal.isCurrentVersion());
        blobItem.setIsPrefix(blobItemInternal.isPrefix());
        HashMap<String, String> tags = new HashMap<String, String>();
        if (blobItemInternal.getBlobTags() != null && blobItemInternal.getBlobTags().getBlobTagSet() != null) {
            for (BlobTag tag : blobItemInternal.getBlobTags().getBlobTagSet()) {
                tags.put(tag.getKey(), tag.getValue());
            }
        }
        blobItem.setTags(tags);
        blobItem.setObjectReplicationSourcePolicies(ModelHelper.transformObjectReplicationMetadata(blobItemInternal.getObjectReplicationMetadata()));
        return blobItem;
    }

    public static BlobItemProperties populateBlobItemProperties(BlobItemPropertiesInternal blobItemPropertiesInternal) {
        BlobItemProperties blobItemProperties = new BlobItemProperties();
        blobItemProperties.setCreationTime(blobItemPropertiesInternal.getCreationTime());
        blobItemProperties.setLastModified(blobItemPropertiesInternal.getLastModified());
        blobItemProperties.setETag(blobItemPropertiesInternal.getETag());
        blobItemProperties.setContentLength(blobItemPropertiesInternal.getContentLength());
        blobItemProperties.setContentType(blobItemPropertiesInternal.getContentType());
        blobItemProperties.setContentEncoding(blobItemPropertiesInternal.getContentEncoding());
        blobItemProperties.setContentLanguage(blobItemPropertiesInternal.getContentLanguage());
        blobItemProperties.setContentMd5(blobItemPropertiesInternal.getContentMd5());
        blobItemProperties.setContentDisposition(blobItemPropertiesInternal.getContentDisposition());
        blobItemProperties.setCacheControl(blobItemPropertiesInternal.getCacheControl());
        blobItemProperties.setBlobSequenceNumber(blobItemPropertiesInternal.getBlobSequenceNumber());
        blobItemProperties.setBlobType(blobItemPropertiesInternal.getBlobType());
        blobItemProperties.setLeaseStatus(blobItemPropertiesInternal.getLeaseStatus());
        blobItemProperties.setLeaseState(blobItemPropertiesInternal.getLeaseState());
        blobItemProperties.setLeaseDuration(blobItemPropertiesInternal.getLeaseDuration());
        blobItemProperties.setCopyId(blobItemPropertiesInternal.getCopyId());
        blobItemProperties.setCopyStatus(blobItemPropertiesInternal.getCopyStatus());
        blobItemProperties.setCopySource(blobItemPropertiesInternal.getCopySource());
        blobItemProperties.setCopyProgress(blobItemPropertiesInternal.getCopyProgress());
        blobItemProperties.setCopyCompletionTime(blobItemPropertiesInternal.getCopyCompletionTime());
        blobItemProperties.setCopyStatusDescription(blobItemPropertiesInternal.getCopyStatusDescription());
        blobItemProperties.setServerEncrypted(blobItemPropertiesInternal.isServerEncrypted());
        blobItemProperties.setIncrementalCopy(blobItemPropertiesInternal.isIncrementalCopy());
        blobItemProperties.setDestinationSnapshot(blobItemPropertiesInternal.getDestinationSnapshot());
        blobItemProperties.setDeletedTime(blobItemPropertiesInternal.getDeletedTime());
        blobItemProperties.setRemainingRetentionDays(blobItemPropertiesInternal.getRemainingRetentionDays());
        blobItemProperties.setAccessTier(blobItemPropertiesInternal.getAccessTier());
        blobItemProperties.setAccessTierInferred(blobItemPropertiesInternal.isAccessTierInferred());
        blobItemProperties.setArchiveStatus(blobItemPropertiesInternal.getArchiveStatus());
        blobItemProperties.setCustomerProvidedKeySha256(blobItemPropertiesInternal.getCustomerProvidedKeySha256());
        blobItemProperties.setEncryptionScope(blobItemPropertiesInternal.getEncryptionScope());
        blobItemProperties.setAccessTierChangeTime(blobItemPropertiesInternal.getAccessTierChangeTime());
        blobItemProperties.setTagCount(blobItemPropertiesInternal.getTagCount());
        blobItemProperties.setRehydratePriority(blobItemPropertiesInternal.getRehydratePriority());
        blobItemProperties.setSealed(blobItemPropertiesInternal.isSealed());
        return blobItemProperties;
    }

    private static List<ObjectReplicationPolicy> transformObjectReplicationMetadata(Map<String, String> objectReplicationMetadata) {
        HashMap internalSourcePolicies = new HashMap();
        objectReplicationMetadata = objectReplicationMetadata == null ? new HashMap() : objectReplicationMetadata;
        for (Map.Entry entry : objectReplicationMetadata.entrySet()) {
            String orString = (String)entry.getKey();
            String str = orString.startsWith("or-") ? orString.substring(3) : orString;
            String[] split = str.split("_");
            String policyId = split[0];
            String ruleId = split[1];
            ObjectReplicationRule rule = new ObjectReplicationRule(ruleId, ObjectReplicationStatus.fromString((String)entry.getValue()));
            if (!internalSourcePolicies.containsKey(policyId)) {
                internalSourcePolicies.put(policyId, new ArrayList());
            }
            ((List)internalSourcePolicies.get(policyId)).add(rule);
        }
        if (internalSourcePolicies.isEmpty()) {
            return null;
        }
        ArrayList<ObjectReplicationPolicy> objectReplicationSourcePolicies = new ArrayList<ObjectReplicationPolicy>();
        for (Map.Entry entry : internalSourcePolicies.entrySet()) {
            objectReplicationSourcePolicies.add(new ObjectReplicationPolicy((String)entry.getKey(), (List)entry.getValue()));
        }
        return objectReplicationSourcePolicies;
    }

    public static BlobLeaseRequestConditions populateBlobLeaseRequestConditions(RequestConditions requestConditions) {
        if (requestConditions == null) {
            return null;
        }
        return new BlobLeaseRequestConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince()).setTagsConditions(null);
    }

    public static BlobBeginCopySourceRequestConditions populateBlobSourceRequestConditions(RequestConditions requestConditions) {
        if (requestConditions == null) {
            return null;
        }
        return new BlobBeginCopySourceRequestConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince()).setTagsConditions(null);
    }

    public static PageBlobCopyIncrementalRequestConditions populateBlobDestinationRequestConditions(RequestConditions requestConditions) {
        if (requestConditions == null) {
            return null;
        }
        return new PageBlobCopyIncrementalRequestConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince()).setTagsConditions(null);
    }
}

