// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.blob.models;

import com.azure.core.annotation.Fluent;
import com.azure.storage.blob.implementation.models.PageListHelper;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;

/** the list of pages. */
@JacksonXmlRootElement(localName = "PageList")
@Fluent
@JsonDeserialize(using = PageListDeserializer.class)
public final class PageList {

    static {
        PageListHelper.setAccessor(
                new PageListHelper.PageListAccessor() {

                    @Override
                    public String getNextMarker(PageList pageList) {
                        return pageList.getNextMarker();
                    }

                    @Override
                    public PageList setNextMarker(PageList pageList, String marker) {
                        return pageList.setNextMarker(marker);
                    }
                });
    }

    /*
     * The PageRange property.
     */
    @JsonProperty("PageRange")
    private List<PageRange> pageRange = new ArrayList<>();

    /*
     * The ClearRange property.
     */
    @JsonProperty("ClearRange")
    private List<ClearRange> clearRange = new ArrayList<>();

    /*
     * The NextMarker property.
     */
    @JsonProperty(value = "NextMarker")
    private String nextMarker;

    /** Creates an instance of PageList class. */
    public PageList() {}

    /**
     * Get the pageRange property: The PageRange property.
     *
     * @return the pageRange value.
     */
    public List<PageRange> getPageRange() {
        return this.pageRange;
    }

    /**
     * Set the pageRange property: The PageRange property.
     *
     * @param pageRange the pageRange value to set.
     * @return the PageList object itself.
     */
    public PageList setPageRange(List<PageRange> pageRange) {
        this.pageRange = pageRange;
        return this;
    }

    /**
     * Get the clearRange property: The ClearRange property.
     *
     * @return the clearRange value.
     */
    public List<ClearRange> getClearRange() {
        return this.clearRange;
    }

    /**
     * Set the clearRange property: The ClearRange property.
     *
     * @param clearRange the clearRange value to set.
     * @return the PageList object itself.
     */
    public PageList setClearRange(List<ClearRange> clearRange) {
        this.clearRange = clearRange;
        return this;
    }

    /**
     * Get the nextMarker property: The NextMarker property.
     *
     * @return the nextMarker value.
     */
    private String getNextMarker() {
        return this.nextMarker;
    }

    /**
     * Set the nextMarker property: The NextMarker property.
     *
     * @param nextMarker the nextMarker value to set.
     * @return the PageList object itself.
     */
    private PageList setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }
}
