// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/** Groups the set of query request settings. */
@JacksonXmlRootElement(localName = "QueryRequest")
@Fluent
public final class QueryRequest {
    /*
     * Required. The type of the provided query expression.
     */
    @JsonProperty(value = "QueryType", required = true)
    private String queryType;

    /*
     * The query expression in SQL. The maximum size of the query expression is 256KiB.
     */
    @JsonProperty(value = "Expression", required = true)
    private String expression;

    /*
     * The InputSerialization property.
     */
    @JsonProperty(value = "InputSerialization")
    private QuerySerialization inputSerialization;

    /*
     * The OutputSerialization property.
     */
    @JsonProperty(value = "OutputSerialization")
    private QuerySerialization outputSerialization;

    /** Creates an instance of QueryRequest class. */
    public QueryRequest() {
        queryType = "SQL";
    }

    /**
     * Get the queryType property: Required. The type of the provided query expression.
     *
     * @return the queryType value.
     */
    public String getQueryType() {
        return this.queryType;
    }

    /**
     * Set the queryType property: Required. The type of the provided query expression.
     *
     * @param queryType the queryType value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest setQueryType(String queryType) {
        this.queryType = queryType;
        return this;
    }

    /**
     * Get the expression property: The query expression in SQL. The maximum size of the query expression is 256KiB.
     *
     * @return the expression value.
     */
    public String getExpression() {
        return this.expression;
    }

    /**
     * Set the expression property: The query expression in SQL. The maximum size of the query expression is 256KiB.
     *
     * @param expression the expression value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest setExpression(String expression) {
        this.expression = expression;
        return this;
    }

    /**
     * Get the inputSerialization property: The InputSerialization property.
     *
     * @return the inputSerialization value.
     */
    public QuerySerialization getInputSerialization() {
        return this.inputSerialization;
    }

    /**
     * Set the inputSerialization property: The InputSerialization property.
     *
     * @param inputSerialization the inputSerialization value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest setInputSerialization(QuerySerialization inputSerialization) {
        this.inputSerialization = inputSerialization;
        return this;
    }

    /**
     * Get the outputSerialization property: The OutputSerialization property.
     *
     * @return the outputSerialization value.
     */
    public QuerySerialization getOutputSerialization() {
        return this.outputSerialization;
    }

    /**
     * Set the outputSerialization property: The OutputSerialization property.
     *
     * @param outputSerialization the outputSerialization value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest setOutputSerialization(QuerySerialization outputSerialization) {
        this.outputSerialization = outputSerialization;
        return this;
    }
}
