/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.AccountKind;
import com.azure.storage.blob.models.SkuName;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="null")
public final class ServicesGetAccountInfoHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-account-kind")
    private AccountKind xMsAccountKind;
    @JsonProperty(value="x-ms-is-hns-enabled")
    private Boolean xMsIsHnsEnabled;
    @JsonProperty(value="x-ms-sku-name")
    private SkuName xMsSkuName;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-client-request-id")
    private String xMsClientRequestId;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;

    public ServicesGetAccountInfoHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        if (rawHeaders.getValue("x-ms-account-kind") != null) {
            this.xMsAccountKind = AccountKind.fromString(rawHeaders.getValue("x-ms-account-kind"));
        }
        if (rawHeaders.getValue("x-ms-is-hns-enabled") != null) {
            this.xMsIsHnsEnabled = Boolean.parseBoolean(rawHeaders.getValue("x-ms-is-hns-enabled"));
        }
        if (rawHeaders.getValue("x-ms-sku-name") != null) {
            this.xMsSkuName = SkuName.fromString(rawHeaders.getValue("x-ms-sku-name"));
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        this.xMsClientRequestId = rawHeaders.getValue("x-ms-client-request-id");
        if (rawHeaders.getValue("Date") != null) {
            this.dateProperty = new DateTimeRfc1123(rawHeaders.getValue("Date"));
        }
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public ServicesGetAccountInfoHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public AccountKind getXMsAccountKind() {
        return this.xMsAccountKind;
    }

    public ServicesGetAccountInfoHeaders setXMsAccountKind(AccountKind xMsAccountKind) {
        this.xMsAccountKind = xMsAccountKind;
        return this;
    }

    public Boolean isXMsIsHnsEnabled() {
        return this.xMsIsHnsEnabled;
    }

    public ServicesGetAccountInfoHeaders setXMsIsHnsEnabled(Boolean xMsIsHnsEnabled) {
        this.xMsIsHnsEnabled = xMsIsHnsEnabled;
        return this;
    }

    public SkuName getXMsSkuName() {
        return this.xMsSkuName;
    }

    public ServicesGetAccountInfoHeaders setXMsSkuName(SkuName xMsSkuName) {
        this.xMsSkuName = xMsSkuName;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public ServicesGetAccountInfoHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public ServicesGetAccountInfoHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public ServicesGetAccountInfoHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }
}

