// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/** Groups the settings used for interpreting the blob data if the blob is delimited text formatted. */
@JacksonXmlRootElement(localName = "DelimitedTextConfiguration")
@Fluent
public final class DelimitedTextConfiguration {
    /*
     * The string used to separate columns.
     */
    @JsonProperty(value = "ColumnSeparator")
    private String columnSeparator;

    /*
     * The string used to quote a specific field.
     */
    @JsonProperty(value = "FieldQuote")
    private String fieldQuote;

    /*
     * The string used to separate records.
     */
    @JsonProperty(value = "RecordSeparator")
    private String recordSeparator;

    /*
     * The string used as an escape character.
     */
    @JsonProperty(value = "EscapeChar")
    private String escapeChar;

    /*
     * Represents whether the data has headers.
     */
    @JsonProperty(value = "HasHeaders")
    private Boolean headersPresent;

    /**
     * Get the columnSeparator property: The string used to separate columns.
     *
     * @return the columnSeparator value.
     */
    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    /**
     * Set the columnSeparator property: The string used to separate columns.
     *
     * @param columnSeparator the columnSeparator value to set.
     * @return the DelimitedTextConfiguration object itself.
     */
    public DelimitedTextConfiguration setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
        return this;
    }

    /**
     * Get the fieldQuote property: The string used to quote a specific field.
     *
     * @return the fieldQuote value.
     */
    public String getFieldQuote() {
        return this.fieldQuote;
    }

    /**
     * Set the fieldQuote property: The string used to quote a specific field.
     *
     * @param fieldQuote the fieldQuote value to set.
     * @return the DelimitedTextConfiguration object itself.
     */
    public DelimitedTextConfiguration setFieldQuote(String fieldQuote) {
        this.fieldQuote = fieldQuote;
        return this;
    }

    /**
     * Get the recordSeparator property: The string used to separate records.
     *
     * @return the recordSeparator value.
     */
    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    /**
     * Set the recordSeparator property: The string used to separate records.
     *
     * @param recordSeparator the recordSeparator value to set.
     * @return the DelimitedTextConfiguration object itself.
     */
    public DelimitedTextConfiguration setRecordSeparator(String recordSeparator) {
        this.recordSeparator = recordSeparator;
        return this;
    }

    /**
     * Get the escapeChar property: The string used as an escape character.
     *
     * @return the escapeChar value.
     */
    public String getEscapeChar() {
        return this.escapeChar;
    }

    /**
     * Set the escapeChar property: The string used as an escape character.
     *
     * @param escapeChar the escapeChar value to set.
     * @return the DelimitedTextConfiguration object itself.
     */
    public DelimitedTextConfiguration setEscapeChar(String escapeChar) {
        this.escapeChar = escapeChar;
        return this;
    }

    /**
     * Get the headersPresent property: Represents whether the data has headers.
     *
     * @return the headersPresent value.
     */
    public Boolean isHeadersPresent() {
        return this.headersPresent;
    }

    /**
     * Set the headersPresent property: Represents whether the data has headers.
     *
     * @param headersPresent the headersPresent value to set.
     * @return the DelimitedTextConfiguration object itself.
     */
    public DelimitedTextConfiguration setHeadersPresent(Boolean headersPresent) {
        this.headersPresent = headersPresent;
        return this;
    }
}
