// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.storage.blob.models.BlobContainerItem;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;

/** An enumeration of containers. */
@JacksonXmlRootElement(localName = "EnumerationResults")
@Fluent
public final class BlobContainersSegment {
    /*
     * The ServiceEndpoint property.
     */
    @JacksonXmlProperty(localName = "ServiceEndpoint", isAttribute = true)
    private String serviceEndpoint;

    /*
     * The Prefix property.
     */
    @JsonProperty(value = "Prefix")
    private String prefix;

    /*
     * The Marker property.
     */
    @JsonProperty(value = "Marker")
    private String marker;

    /*
     * The MaxResults property.
     */
    @JsonProperty(value = "MaxResults")
    private Integer maxResults;

    /*
     * The NextMarker property.
     */
    @JsonProperty(value = "NextMarker", required = true)
    private String nextMarker;

    private static final class ContainersWrapper {
        @JacksonXmlProperty(localName = "Container")
        private final List<BlobContainerItem> items;

        @JsonCreator
        private ContainersWrapper(@JacksonXmlProperty(localName = "Container") List<BlobContainerItem> items) {
            this.items = items;
        }
    }

    /*
     * The BlobContainerItems property.
     */
    @JsonProperty(value = "Containers")
    private ContainersWrapper blobContainerItems;

    /**
     * Get the serviceEndpoint property: The ServiceEndpoint property.
     *
     * @return the serviceEndpoint value.
     */
    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    /**
     * Set the serviceEndpoint property: The ServiceEndpoint property.
     *
     * @param serviceEndpoint the serviceEndpoint value to set.
     * @return the BlobContainersSegment object itself.
     */
    public BlobContainersSegment setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    /**
     * Get the prefix property: The Prefix property.
     *
     * @return the prefix value.
     */
    public String getPrefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: The Prefix property.
     *
     * @param prefix the prefix value to set.
     * @return the BlobContainersSegment object itself.
     */
    public BlobContainersSegment setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Get the marker property: The Marker property.
     *
     * @return the marker value.
     */
    public String getMarker() {
        return this.marker;
    }

    /**
     * Set the marker property: The Marker property.
     *
     * @param marker the marker value to set.
     * @return the BlobContainersSegment object itself.
     */
    public BlobContainersSegment setMarker(String marker) {
        this.marker = marker;
        return this;
    }

    /**
     * Get the maxResults property: The MaxResults property.
     *
     * @return the maxResults value.
     */
    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * Set the maxResults property: The MaxResults property.
     *
     * @param maxResults the maxResults value to set.
     * @return the BlobContainersSegment object itself.
     */
    public BlobContainersSegment setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    /**
     * Get the nextMarker property: The NextMarker property.
     *
     * @return the nextMarker value.
     */
    public String getNextMarker() {
        return this.nextMarker;
    }

    /**
     * Set the nextMarker property: The NextMarker property.
     *
     * @param nextMarker the nextMarker value to set.
     * @return the BlobContainersSegment object itself.
     */
    public BlobContainersSegment setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    /**
     * Get the blobContainerItems property: The BlobContainerItems property.
     *
     * @return the blobContainerItems value.
     */
    public List<BlobContainerItem> getBlobContainerItems() {
        if (this.blobContainerItems == null) {
            this.blobContainerItems = new ContainersWrapper(new ArrayList<BlobContainerItem>());
        }
        return this.blobContainerItems.items;
    }

    /**
     * Set the blobContainerItems property: The BlobContainerItems property.
     *
     * @param blobContainerItems the blobContainerItems value to set.
     * @return the BlobContainersSegment object itself.
     */
    public BlobContainersSegment setBlobContainerItems(List<BlobContainerItem> blobContainerItems) {
        this.blobContainerItems = new ContainersWrapper(blobContainerItems);
        return this;
    }
}
