// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for BlobCopySourceTags. */
public final class BlobCopySourceTagsMode extends ExpandableStringEnum<BlobCopySourceTagsMode> {
    /** Static value REPLACE for BlobCopySourceTags. */
    public static final BlobCopySourceTagsMode REPLACE = fromString("REPLACE");

    /** Static value COPY for BlobCopySourceTags. */
    public static final BlobCopySourceTagsMode COPY = fromString("COPY");

    /**
     * Creates or finds a BlobCopySourceTags from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding BlobCopySourceTags.
     */
    @JsonCreator
    public static BlobCopySourceTagsMode fromString(String name) {
        return fromString(name, BlobCopySourceTagsMode.class);
    }

    /** @return known BlobCopySourceTags values. */
    public static Collection<BlobCopySourceTagsMode> values() {
        return values(BlobCopySourceTagsMode.class);
    }
}
