/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.models.AppendBlobsAppendBlockFromUrlHeaders;
import com.azure.storage.blob.implementation.models.AppendBlobsAppendBlockHeaders;
import com.azure.storage.blob.implementation.models.AppendBlobsCreateHeaders;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.models.AppendBlobItem;
import com.azure.storage.blob.models.AppendBlobRequestConditions;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.options.AppendBlobAppendBlockFromUrlOptions;
import com.azure.storage.blob.options.AppendBlobCreateOptions;
import com.azure.storage.blob.options.AppendBlobSealOptions;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SpecializedBlobClientBuilder.class, isAsync=true)
public final class AppendBlobAsyncClient
extends BlobAsyncClientBase {
    private static final ClientLogger LOGGER = new ClientLogger(AppendBlobAsyncClient.class);
    public static final int MAX_APPEND_BLOCK_BYTES = 0x400000;
    public static final int MAX_BLOCKS = 50000;

    AppendBlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, String versionId) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, versionId);
    }

    @Override
    public AppendBlobAsyncClient getEncryptionScopeAsyncClient(String encryptionScope) {
        EncryptionScope finalEncryptionScope = null;
        if (encryptionScope != null) {
            finalEncryptionScope = new EncryptionScope().setEncryptionScope(encryptionScope);
        }
        return new AppendBlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), finalEncryptionScope, this.getVersionId());
    }

    @Override
    public AppendBlobAsyncClient getCustomerProvidedKeyAsyncClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new AppendBlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), finalCustomerProvidedKey, this.encryptionScope, this.getVersionId());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppendBlobItem> create() {
        return this.create(false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppendBlobItem> create(boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return this.createWithResponse(null, null, blobRequestConditions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AppendBlobItem>> createWithResponse(BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions) {
        return this.createWithResponse(new AppendBlobCreateOptions().setHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AppendBlobItem>> createWithResponse(AppendBlobCreateOptions options) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<AppendBlobItem>> createWithResponse(AppendBlobCreateOptions options, Context context) {
        options = options == null ? new AppendBlobCreateOptions() : options;
        BlobRequestConditions requestConditions = options.getRequestConditions();
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        BlobImmutabilityPolicy immutabilityPolicy = options.getImmutabilityPolicy() == null ? new BlobImmutabilityPolicy() : options.getImmutabilityPolicy();
        return this.azureBlobStorage.getAppendBlobs().createWithResponseAsync(this.containerName, this.blobName, 0L, null, options.getMetadata(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, this.tagsToString(options.getTags()), immutabilityPolicy.getExpiryTime(), immutabilityPolicy.getPolicyMode(), options.hasLegalHold(), options.getHeaders(), this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            AppendBlobsCreateHeaders hd = (AppendBlobsCreateHeaders)rb.getDeserializedHeaders();
            AppendBlobItem item = new AppendBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), null, null, hd.getXMsVersionId());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppendBlobItem> appendBlock(Flux<ByteBuffer> data, long length) {
        return this.appendBlockWithResponse(data, length, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AppendBlobItem>> appendBlockWithResponse(Flux<ByteBuffer> data, long length, byte[] contentMd5, AppendBlobRequestConditions appendBlobRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.appendBlockWithResponse(data, length, contentMd5, appendBlobRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<AppendBlobItem>> appendBlockWithResponse(Flux<ByteBuffer> data, long length, byte[] contentMd5, AppendBlobRequestConditions appendBlobRequestConditions, Context context) {
        appendBlobRequestConditions = appendBlobRequestConditions == null ? new AppendBlobRequestConditions() : appendBlobRequestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getAppendBlobs().appendBlockWithResponseAsync(this.containerName, this.blobName, length, data, null, contentMd5, null, appendBlobRequestConditions.getLeaseId(), appendBlobRequestConditions.getMaxSize(), appendBlobRequestConditions.getAppendPosition(), appendBlobRequestConditions.getIfModifiedSince(), appendBlobRequestConditions.getIfUnmodifiedSince(), appendBlobRequestConditions.getIfMatch(), appendBlobRequestConditions.getIfNoneMatch(), appendBlobRequestConditions.getTagsConditions(), null, this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            AppendBlobsAppendBlockHeaders hd = (AppendBlobsAppendBlockHeaders)rb.getDeserializedHeaders();
            AppendBlobItem item = new AppendBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), hd.getXMsBlobAppendOffset(), hd.getXMsBlobCommittedBlockCount());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppendBlobItem> appendBlockFromUrl(String sourceUrl, BlobRange sourceRange) {
        return this.appendBlockFromUrlWithResponse(sourceUrl, sourceRange, null, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AppendBlobItem>> appendBlockFromUrlWithResponse(String sourceUrl, BlobRange sourceRange, byte[] sourceContentMD5, AppendBlobRequestConditions destRequestConditions, BlobRequestConditions sourceRequestConditions) {
        return this.appendBlockFromUrlWithResponse(new AppendBlobAppendBlockFromUrlOptions(sourceUrl).setSourceRange(sourceRange).setSourceContentMd5(sourceContentMD5).setDestinationRequestConditions(destRequestConditions).setSourceRequestConditions(sourceRequestConditions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AppendBlobItem>> appendBlockFromUrlWithResponse(AppendBlobAppendBlockFromUrlOptions options) {
        try {
            return FluxUtil.withContext(context -> this.appendBlockFromUrlWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<AppendBlobItem>> appendBlockFromUrlWithResponse(AppendBlobAppendBlockFromUrlOptions options, Context context) {
        BlobRange sourceRange = options.getSourceRange() == null ? new BlobRange(0L) : options.getSourceRange();
        AppendBlobRequestConditions destRequestConditions = options.getDestinationRequestConditions() == null ? new AppendBlobRequestConditions() : options.getDestinationRequestConditions();
        RequestConditions sourceRequestConditions = options.getSourceRequestConditions() == null ? new RequestConditions() : options.getSourceRequestConditions();
        try {
            new URL(options.getSourceUrl());
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sourceUrl' is not a valid url.", ex));
        }
        context = context == null ? Context.NONE : context;
        String sourceAuth = options.getSourceAuthorization() == null ? null : options.getSourceAuthorization().toString();
        return this.azureBlobStorage.getAppendBlobs().appendBlockFromUrlWithResponseAsync(this.containerName, this.blobName, options.getSourceUrl(), 0L, sourceRange.toString(), options.getSourceContentMd5(), null, null, null, destRequestConditions.getLeaseId(), destRequestConditions.getMaxSize(), destRequestConditions.getAppendPosition(), destRequestConditions.getIfModifiedSince(), destRequestConditions.getIfUnmodifiedSince(), destRequestConditions.getIfMatch(), destRequestConditions.getIfNoneMatch(), destRequestConditions.getTagsConditions(), sourceRequestConditions.getIfModifiedSince(), sourceRequestConditions.getIfUnmodifiedSince(), sourceRequestConditions.getIfMatch(), sourceRequestConditions.getIfNoneMatch(), null, sourceAuth, this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            AppendBlobsAppendBlockFromUrlHeaders hd = (AppendBlobsAppendBlockFromUrlHeaders)rb.getDeserializedHeaders();
            AppendBlobItem item = new AppendBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), hd.getXMsBlobAppendOffset(), hd.getXMsBlobCommittedBlockCount());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> seal() {
        return this.sealWithResponse(new AppendBlobSealOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sealWithResponse(AppendBlobSealOptions options) {
        try {
            return FluxUtil.withContext(context -> this.sealWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> sealWithResponse(AppendBlobSealOptions options, Context context) {
        options = options == null ? new AppendBlobSealOptions() : options;
        AppendBlobRequestConditions requestConditions = options.getRequestConditions();
        requestConditions = requestConditions == null ? new AppendBlobRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getAppendBlobs().sealWithResponseAsync(this.containerName, this.blobName, null, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getAppendPosition(), context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }
}

