/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.AccountKind;
import com.azure.storage.blob.models.SkuName;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="Service-GetAccountInfo-Headers")
public final class ServiceGetAccountInfoHeaders {
    @JsonProperty(value="x-ms-client-request-id")
    private String clientRequestId;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-sku-name")
    private SkuName skuName;
    @JsonProperty(value="x-ms-account-kind")
    private AccountKind accountKind;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public ServiceGetAccountInfoHeaders setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public ServiceGetAccountInfoHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ServiceGetAccountInfoHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public ServiceGetAccountInfoHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public SkuName getSkuName() {
        return this.skuName;
    }

    public ServiceGetAccountInfoHeaders setSkuName(SkuName skuName) {
        this.skuName = skuName;
        return this;
    }

    public AccountKind getAccountKind() {
        return this.accountKind;
    }

    public ServiceGetAccountInfoHeaders setAccountKind(AccountKind accountKind) {
        this.accountKind = accountKind;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public ServiceGetAccountInfoHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

