/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.ContainerGetAccessPolicyHeaders;
import com.azure.storage.blob.implementation.models.ContainerGetAccountInfoHeaders;
import com.azure.storage.blob.implementation.models.ContainerGetPropertiesHeaders;
import com.azure.storage.blob.implementation.models.ContainerListBlobFlatSegmentHeaders;
import com.azure.storage.blob.implementation.models.ContainerListBlobHierarchySegmentHeaders;
import com.azure.storage.blob.implementation.models.ContainersListBlobFlatSegmentResponse;
import com.azure.storage.blob.implementation.models.ContainersListBlobHierarchySegmentResponse;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.util.BlobSasImplUtil;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobContainerAccessPolicies;
import com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.azure.storage.blob.models.BlobContainerProperties;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobSignedIdentifier;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.ListBlobsIncludeItem;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Mono;

public final class BlobContainerAsyncClient {
    public static final String ROOT_CONTAINER_NAME = "$root";
    public static final String STATIC_WEBSITE_CONTAINER_NAME = "$web";
    public static final String LOG_CONTAINER_NAME = "$logs";
    private final ClientLogger logger = new ClientLogger(BlobContainerAsyncClient.class);
    private final AzureBlobStorageImpl azureBlobStorage;
    private final String accountName;
    private final String containerName;
    private final BlobServiceVersion serviceVersion;
    private final CpkInfo customerProvidedKey;
    private final EncryptionScope encryptionScope;
    private final BlobContainerEncryptionScope blobContainerEncryptionScope;

    BlobContainerAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, BlobContainerEncryptionScope blobContainerEncryptionScope) {
        try {
            URI.create(url);
        }
        catch (IllegalArgumentException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)ex);
        }
        this.azureBlobStorage = new AzureBlobStorageBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).build();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.containerName = containerName;
        this.customerProvidedKey = customerProvidedKey;
        this.encryptionScope = encryptionScope;
        this.blobContainerEncryptionScope = blobContainerEncryptionScope;
    }

    public BlobAsyncClient getBlobAsyncClient(String blobName) {
        return this.getBlobAsyncClient(blobName, null);
    }

    public BlobAsyncClient getBlobAsyncClient(String blobName, String snapshot) {
        return new BlobAsyncClient(this.getHttpPipeline(), StorageImplUtils.appendToUrlPath((String)this.getBlobContainerUrl(), (String)Utility.urlEncode((String)Utility.urlDecode((String)blobName))).toString(), this.getServiceVersion(), this.getAccountName(), this.getBlobContainerName(), blobName, snapshot, this.getCustomerProvidedKey(), this.encryptionScope);
    }

    public BlobAsyncClient getBlobVersionAsyncClient(String blobName, String versionId) {
        return new BlobAsyncClient(this.getHttpPipeline(), StorageImplUtils.appendToUrlPath((String)this.getBlobContainerUrl(), (String)Utility.urlEncode((String)Utility.urlDecode((String)blobName))).toString(), this.getServiceVersion(), this.getAccountName(), this.getBlobContainerName(), blobName, null, this.getCustomerProvidedKey(), this.encryptionScope, versionId);
    }

    public String getBlobContainerUrl() {
        return this.azureBlobStorage.getUrl();
    }

    public String getBlobContainerName() {
        return this.containerName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public BlobServiceAsyncClient getServiceAsyncClient() {
        return this.getServiceClientBuilder().buildAsyncClient();
    }

    BlobServiceClientBuilder getServiceClientBuilder() {
        CustomerProvidedKey encryptionKey = this.customerProvidedKey == null ? null : new CustomerProvidedKey(this.customerProvidedKey.getEncryptionKey());
        return new BlobServiceClientBuilder().endpoint(this.getBlobContainerUrl()).pipeline(this.getHttpPipeline()).serviceVersion(this.serviceVersion).blobContainerEncryptionScope(this.blobContainerEncryptionScope).encryptionScope(this.getEncryptionScope()).customerProvidedKey(encryptionKey);
    }

    public BlobServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureBlobStorage.getHttpPipeline();
    }

    public CpkInfo getCustomerProvidedKey() {
        return this.customerProvidedKey;
    }

    public String getEncryptionScope() {
        if (this.encryptionScope == null) {
            return null;
        }
        return this.encryptionScope.getEncryptionScope();
    }

    public Mono<Boolean> exists() {
        try {
            return this.existsWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Boolean>> existsWithResponse() {
        try {
            return FluxUtil.withContext(this::existsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> existsWithResponse(Context context) {
        return this.getPropertiesWithResponse(null, context).map(cp -> new SimpleResponse(cp, (Object)true)).onErrorResume(t -> t instanceof BlobStorageException && ((BlobStorageException)((Object)((Object)t))).getStatusCode() == 404, t -> {
            HttpResponse response = ((BlobStorageException)((Object)((Object)t))).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
        });
    }

    public Mono<Void> create() {
        try {
            return this.createWithResponse(null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> createWithResponse(Map<String, String> metadata, PublicAccessType accessType) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(metadata, accessType, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> createWithResponse(Map<String, String> metadata, PublicAccessType accessType, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.containers().createWithRestResponseAsync(null, null, metadata, accessType, null, this.blobContainerEncryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Void> delete() {
        try {
            return this.deleteWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteWithResponse(BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteWithResponse(requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(BlobRequestConditions requestConditions, Context context) {
        BlobRequestConditions blobRequestConditions = requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (!this.validateNoETag(requestConditions)) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("ETag access conditions are not supported for this API."));
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.containers().deleteWithRestResponseAsync(null, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<BlobContainerProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlobContainerProperties>> getPropertiesWithResponse(String leaseId) {
        try {
            return FluxUtil.withContext(context -> this.getPropertiesWithResponse(leaseId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobContainerProperties>> getPropertiesWithResponse(String leaseId, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.containers().getPropertiesWithRestResponseAsync(null, null, leaseId, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            ContainerGetPropertiesHeaders hd = (ContainerGetPropertiesHeaders)rb.getDeserializedHeaders();
            BlobContainerProperties properties = new BlobContainerProperties(hd.getMetadata(), hd.getETag(), hd.getLastModified(), hd.getLeaseDuration(), hd.getLeaseState(), hd.getLeaseStatus(), hd.getBlobPublicAccess(), Boolean.TRUE.equals(hd.isHasImmutabilityPolicy()), Boolean.TRUE.equals(hd.isHasLegalHold()), hd.getDefaultEncryptionScope(), hd.isDenyEncryptionScopeOverride());
            return new SimpleResponse((Response)rb, (Object)properties);
        });
    }

    public Mono<Void> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setMetadataWithResponse(metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Context context) {
        context = context == null ? Context.NONE : context;
        BlobRequestConditions blobRequestConditions = requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (!this.validateNoETag(requestConditions) || requestConditions.getIfUnmodifiedSince() != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("If-Modified-Since is the only HTTP access condition supported for this API"));
        }
        return this.azureBlobStorage.containers().setMetadataWithRestResponseAsync(null, null, requestConditions.getLeaseId(), metadata, requestConditions.getIfModifiedSince(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<BlobContainerAccessPolicies> getAccessPolicy() {
        try {
            return this.getAccessPolicyWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlobContainerAccessPolicies>> getAccessPolicyWithResponse(String leaseId) {
        try {
            return FluxUtil.withContext(context -> this.getAccessPolicyWithResponse(leaseId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobContainerAccessPolicies>> getAccessPolicyWithResponse(String leaseId, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.containers().getAccessPolicyWithRestResponseAsync(null, null, leaseId, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)new BlobContainerAccessPolicies(((ContainerGetAccessPolicyHeaders)response.getDeserializedHeaders()).getBlobPublicAccess(), (List<BlobSignedIdentifier>)response.getValue())));
    }

    public Mono<Void> setAccessPolicy(PublicAccessType accessType, List<BlobSignedIdentifier> identifiers) {
        try {
            return this.setAccessPolicyWithResponse(accessType, identifiers, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setAccessPolicyWithResponse(PublicAccessType accessType, List<BlobSignedIdentifier> identifiers, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setAccessPolicyWithResponse(accessType, identifiers, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setAccessPolicyWithResponse(PublicAccessType accessType, List<BlobSignedIdentifier> identifiers, BlobRequestConditions requestConditions, Context context) {
        BlobRequestConditions blobRequestConditions = requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (!this.validateNoETag(requestConditions)) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("ETag access conditions are not supported for this API."));
        }
        if (identifiers != null) {
            for (BlobSignedIdentifier identifier : identifiers) {
                if (identifier.getAccessPolicy() != null && identifier.getAccessPolicy().getStartsOn() != null) {
                    identifier.getAccessPolicy().setStartsOn(identifier.getAccessPolicy().getStartsOn().truncatedTo(ChronoUnit.SECONDS));
                }
                if (identifier.getAccessPolicy() == null || identifier.getAccessPolicy().getExpiresOn() == null) continue;
                identifier.getAccessPolicy().setExpiresOn(identifier.getAccessPolicy().getExpiresOn().truncatedTo(ChronoUnit.SECONDS));
            }
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.containers().setAccessPolicyWithRestResponseAsync(null, identifiers, null, requestConditions.getLeaseId(), accessType, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public PagedFlux<BlobItem> listBlobs() {
        try {
            return this.listBlobs(new ListBlobsOptions());
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<BlobItem> listBlobs(ListBlobsOptions options) {
        try {
            return this.listBlobsFlatWithOptionalTimeout(options, null, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<BlobItem> listBlobs(ListBlobsOptions options, String continuationToken) {
        try {
            return this.listBlobsFlatWithOptionalTimeout(options, continuationToken, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<BlobItem> listBlobsFlatWithOptionalTimeout(ListBlobsOptions options, String continuationToken, Duration timeout) {
        Function<String, Mono> func = marker -> this.listBlobsFlatSegment((String)marker, options, timeout).map(response -> {
            List value = response.getValue().getSegment() == null ? Collections.emptyList() : response.getValue().getSegment().getBlobItems().stream().map(ModelHelper::populateBlobItem).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, response.getValue().getNextMarker(), (Object)((ContainerListBlobFlatSegmentHeaders)response.getDeserializedHeaders()));
        });
        return new PagedFlux(() -> (Mono)func.apply(continuationToken), func);
    }

    private Mono<ContainersListBlobFlatSegmentResponse> listBlobsFlatSegment(String marker, ListBlobsOptions options, Duration timeout) {
        options = options == null ? new ListBlobsOptions() : options;
        ArrayList<ListBlobsIncludeItem> include = options.getDetails().toList().isEmpty() ? null : options.getDetails().toList();
        return StorageImplUtils.applyOptionalTimeout(this.azureBlobStorage.containers().listBlobFlatSegmentWithRestResponseAsync(null, options.getPrefix(), marker, options.getMaxResultsPerPage(), include, null, null, Context.NONE), (Duration)timeout);
    }

    public PagedFlux<BlobItem> listBlobsByHierarchy(String directory) {
        try {
            return this.listBlobsByHierarchy("/", new ListBlobsOptions().setPrefix(directory));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<BlobItem> listBlobsByHierarchy(String delimiter, ListBlobsOptions options) {
        try {
            return this.listBlobsHierarchyWithOptionalTimeout(delimiter, options, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<BlobItem> listBlobsHierarchyWithOptionalTimeout(String delimiter, ListBlobsOptions options, Duration timeout) {
        Function<String, Mono> func = marker -> this.listBlobsHierarchySegment((String)marker, delimiter, options, timeout).map(response -> {
            List value = response.getValue().getSegment() == null ? Collections.emptyList() : Stream.concat(response.getValue().getSegment().getBlobItems().stream().map(ModelHelper::populateBlobItem), response.getValue().getSegment().getBlobPrefixes().stream().map(blobPrefix -> new BlobItem().setName(blobPrefix.getName()).setIsPrefix(true))).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, response.getValue().getNextMarker(), (Object)((ContainerListBlobHierarchySegmentHeaders)response.getDeserializedHeaders()));
        });
        return new PagedFlux(() -> (Mono)func.apply(null), func);
    }

    private Mono<ContainersListBlobHierarchySegmentResponse> listBlobsHierarchySegment(String marker, String delimiter, ListBlobsOptions options, Duration timeout) {
        ListBlobsOptions listBlobsOptions = options = options == null ? new ListBlobsOptions() : options;
        if (options.getDetails().getRetrieveSnapshots()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Including snapshots in a hierarchical listing is not supported."));
        }
        ArrayList<ListBlobsIncludeItem> include = options.getDetails().toList().isEmpty() ? null : options.getDetails().toList();
        return StorageImplUtils.applyOptionalTimeout(this.azureBlobStorage.containers().listBlobHierarchySegmentWithRestResponseAsync(null, delimiter, options.getPrefix(), marker, options.getMaxResultsPerPage(), include, null, null, Context.NONE), (Duration)timeout);
    }

    public Mono<StorageAccountInfo> getAccountInfo() {
        try {
            return this.getAccountInfoWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse() {
        try {
            return FluxUtil.withContext(this::getAccountInfoWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.containers().getAccountInfoWithRestResponseAsync(null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            ContainerGetAccountInfoHeaders hd = (ContainerGetAccountInfoHeaders)rb.getDeserializedHeaders();
            return new SimpleResponse((Response)rb, (Object)new StorageAccountInfo(hd.getSkuName(), hd.getAccountKind()));
        });
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return new BlobSasImplUtil(blobServiceSasSignatureValues, this.getBlobContainerName()).generateUserDelegationSas(userDelegationKey, this.getAccountName());
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues) {
        return new BlobSasImplUtil(blobServiceSasSignatureValues, this.getBlobContainerName()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()));
    }

    private boolean validateNoETag(BlobRequestConditions modifiedRequestConditions) {
        if (modifiedRequestConditions == null) {
            return true;
        }
        return modifiedRequestConditions.getIfMatch() == null && modifiedRequestConditions.getIfNoneMatch() == null;
    }
}

