/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobParallelUploadOptions;
import com.azure.storage.blob.options.BlobUploadFromFileOptions;
import com.azure.storage.blob.specialized.AppendBlobClient;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.blob.specialized.PageBlobClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.UploadUtils;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class BlobClient
extends BlobClientBase {
    private final ClientLogger logger = new ClientLogger(BlobClient.class);
    public static final int BLOB_DEFAULT_UPLOAD_BLOCK_SIZE = 0x400000;
    public static final int BLOB_DEFAULT_NUMBER_OF_BUFFERS = 8;
    public static final int BLOB_DEFAULT_HTBB_UPLOAD_BLOCK_SIZE = 0x800000;
    private final BlobAsyncClient client;

    protected BlobClient(BlobAsyncClient client) {
        super(client);
        this.client = client;
    }

    @Override
    public BlobClient getSnapshotClient(String snapshot) {
        return new BlobClient(this.client.getSnapshotClient(snapshot));
    }

    @Override
    public BlobClient getVersionClient(String versionId) {
        return new BlobClient(this.client.getVersionClient(versionId));
    }

    public AppendBlobClient getAppendBlobClient() {
        return new SpecializedBlobClientBuilder().blobClient(this).buildAppendBlobClient();
    }

    public BlockBlobClient getBlockBlobClient() {
        return new SpecializedBlobClientBuilder().blobClient(this).buildBlockBlobClient();
    }

    public PageBlobClient getPageBlobClient() {
        return new SpecializedBlobClientBuilder().blobClient(this).buildPageBlobClient();
    }

    public void upload(InputStream data, long length) {
        this.upload(data, length, false);
    }

    public void upload(InputStream data, long length, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        this.uploadWithResponse(data, length, null, null, null, null, blobRequestConditions, null, Context.NONE);
    }

    public void uploadWithResponse(InputStream data, long length, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        this.uploadWithResponse(new BlobParallelUploadOptions(data, length).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions), timeout, context);
    }

    @Deprecated
    public Response<BlockBlobItem> uploadWithResponse(BlobParallelUploadOptions options, Context context) {
        Objects.requireNonNull(options);
        return this.uploadWithResponse(options, options.getTimeout(), context);
    }

    public Response<BlockBlobItem> uploadWithResponse(BlobParallelUploadOptions options, Duration timeout, Context context) {
        Objects.requireNonNull(options);
        Mono upload = this.client.uploadWithResponse(options).subscriberContext(FluxUtil.toReactorContext((Context)context));
        try {
            return (Response)StorageImplUtils.blockWithOptionalTimeout((Mono)upload, (Duration)timeout);
        }
        catch (UncheckedIOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)e);
        }
    }

    public void uploadFromFile(String filePath) {
        this.uploadFromFile(filePath, false);
    }

    public void uploadFromFile(String filePath, boolean overwrite) {
        BlobRequestConditions requestConditions = null;
        if (!overwrite) {
            if (UploadUtils.shouldUploadInChunks((String)filePath, (Long)5242880000L, (ClientLogger)this.logger) && this.exists().booleanValue()) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob."));
            }
            requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
        }
        this.uploadFromFile(filePath, null, null, null, null, requestConditions, null);
    }

    public void uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, Duration timeout) {
        this.uploadFromFileWithResponse(new BlobUploadFromFileOptions(filePath).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions), null, null);
    }

    public Response<BlockBlobItem> uploadFromFileWithResponse(BlobUploadFromFileOptions options, Duration timeout, Context context) {
        Mono upload = this.client.uploadFromFileWithResponse(options).subscriberContext(FluxUtil.toReactorContext((Context)context));
        try {
            return (Response)StorageImplUtils.blockWithOptionalTimeout((Mono)upload, (Duration)timeout);
        }
        catch (UncheckedIOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)e);
        }
    }
}

